/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount;

    protected AbstractList() {
    }

    @Override
    public abstract E get(int var1);

    @Override
    public void add(int index, E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        this.add(this.size(), o);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int size;
        Iterator<E> itr = c.iterator();
        int pos = size = c.size();
        while (pos > 0) {
            this.add(index++, itr.next());
            --pos;
        }
        return size > 0;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        int size = this.size();
        if (size != ((List)o).size()) {
            return false;
        }
        Iterator<E> itr1 = this.iterator();
        Iterator itr2 = ((List)o).iterator();
        while (--size >= 0) {
            if (AbstractList.equals(itr1.next(), itr2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        Iterator<E> itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            hashCode = 31 * hashCode + AbstractList.hashCode(itr.next());
        }
        return hashCode;
    }

    @Override
    public int indexOf(Object o) {
        ListIterator<E> itr = this.listIterator();
        int size = this.size();
        int pos = 0;
        while (pos < size) {
            if (AbstractList.equals(o, itr.next())) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int pos = 0;
            private int size;
            private int last;
            private int knownMod;
            {
                this.size = AbstractList.this.size();
                this.last = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            private void checkMod() {
                if (this.knownMod != AbstractList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.size;
            }

            @Override
            public E next() {
                this.checkMod();
                if (this.pos == this.size) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos;
                return AbstractList.this.get(this.pos++);
            }

            @Override
            public void remove() {
                this.checkMod();
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.last);
                --this.pos;
                --this.size;
                this.last = -1;
                this.knownMod = AbstractList.this.modCount;
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        int pos = this.size();
        ListIterator<E> itr = this.listIterator(pos);
        while (--pos >= 0) {
            if (!AbstractList.equals(o, itr.previous())) continue;
            return pos;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size());
        }
        return new ListIterator<E>(index){
            private int knownMod;
            private int position;
            private int lastReturned;
            private int size;
            {
                this.knownMod = AbstractList.this.modCount;
                this.position = n;
                this.lastReturned = -1;
                this.size = AbstractList.this.size();
            }

            private void checkMod() {
                if (this.knownMod != AbstractList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                return this.position < this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.position > 0;
            }

            @Override
            public E next() {
                this.checkMod();
                if (this.position == this.size) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.position;
                return AbstractList.this.get(this.position++);
            }

            @Override
            public E previous() {
                this.checkMod();
                if (this.position == 0) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.position;
                return AbstractList.this.get(this.lastReturned);
            }

            @Override
            public int nextIndex() {
                return this.position;
            }

            @Override
            public int previousIndex() {
                return this.position - 1;
            }

            @Override
            public void remove() {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.lastReturned);
                --this.size;
                this.position = this.lastReturned;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            @Override
            public void set(E o) {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.set(this.lastReturned, o);
            }

            @Override
            public void add(E o) {
                this.checkMod();
                AbstractList.this.add(this.position++, o);
                ++this.size;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }
        };
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator<E> itr = this.listIterator(fromIndex);
        int index = fromIndex;
        while (index < toIndex) {
            itr.next();
            itr.remove();
            ++index;
        }
    }

    @Override
    public E set(int index, E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(String.valueOf(fromIndex) + " > " + toIndex);
        }
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this instanceof RandomAccess) {
            return new RandomAccessSubList(this, fromIndex, toIndex);
        }
        return new SubList(this, fromIndex, toIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RandomAccessSubList<E>
    extends SubList<E>
    implements RandomAccess {
        RandomAccessSubList(AbstractList<E> backing, int fromIndex, int toIndex) {
            super(backing, fromIndex, toIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubList<E>
    extends AbstractList<E> {
        final AbstractList<E> backingList;
        final int offset;
        int size;

        SubList(AbstractList<E> backing, int fromIndex, int toIndex) {
            this.backingList = backing;
            this.modCount = backing.modCount;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        void checkMod() {
            if (this.modCount != this.backingList.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkBoundsInclusive(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
            }
        }

        private void checkBoundsExclusive(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
            }
        }

        @Override
        public int size() {
            this.checkMod();
            return this.size;
        }

        @Override
        public E set(int index, E o) {
            this.checkMod();
            this.checkBoundsExclusive(index);
            return this.backingList.set(index + this.offset, o);
        }

        @Override
        public E get(int index) {
            this.checkMod();
            this.checkBoundsExclusive(index);
            return this.backingList.get(index + this.offset);
        }

        @Override
        public void add(int index, E o) {
            this.checkMod();
            this.checkBoundsInclusive(index);
            this.backingList.add(index + this.offset, o);
            ++this.size;
            this.modCount = this.backingList.modCount;
        }

        @Override
        public E remove(int index) {
            this.checkMod();
            this.checkBoundsExclusive(index);
            E o = this.backingList.remove(index + this.offset);
            --this.size;
            this.modCount = this.backingList.modCount;
            return o;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkMod();
            this.backingList.removeRange(this.offset + fromIndex, this.offset + toIndex);
            this.size -= toIndex - fromIndex;
            this.modCount = this.backingList.modCount;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.checkMod();
            this.checkBoundsInclusive(index);
            int csize = c.size();
            boolean result = this.backingList.addAll(this.offset + index, c);
            this.size += csize;
            this.modCount = this.backingList.modCount;
            return result;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            this.checkMod();
            this.checkBoundsInclusive(index);
            return new ListIterator<E>(this, index){
                private final ListIterator<E> i;
                private int position;
                final /* synthetic */ SubList this$1;
                {
                    this.this$1 = subList;
                    this.i = subList.backingList.listIterator(n + subList.offset);
                    this.position = n;
                }

                public boolean hasNext() {
                    return this.position < this.this$1.size;
                }

                public boolean hasPrevious() {
                    return this.position > 0;
                }

                public E next() {
                    if (this.position == this.this$1.size) {
                        throw new NoSuchElementException();
                    }
                    ++this.position;
                    return this.i.next();
                }

                public E previous() {
                    if (this.position == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.position;
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex() - this.this$1.offset;
                }

                public int previousIndex() {
                    return this.i.previousIndex() - this.this$1.offset;
                }

                public void remove() {
                    this.i.remove();
                    --this.this$1.size;
                    this.position = this.nextIndex();
                    this.this$1.modCount = this.this$1.backingList.modCount;
                }

                public void set(E o) {
                    this.i.set(o);
                }

                public void add(E o) {
                    this.i.add(o);
                    ++this.this$1.size;
                    ++this.position;
                    this.this$1.modCount = this.this$1.backingList.modCount;
                }
            };
        }
    }
}

