/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.lang.CPStringBuilder;
import gnu.java.text.AttributedFormatBuffer;
import gnu.java.text.FormatBuffer;
import gnu.java.text.FormatCharacterIterator;
import gnu.java.text.StringFormatBuffer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleDateFormat
extends DateFormat {
    private transient ArrayList<Object> tokens;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCentury;
    private String pattern;
    private int serialVersionOnStream = 1;
    private static final long serialVersionUID = 4774881970558875024L;
    private static final String standardChars = "GyMdkHmsSEDFwWahKzYeugAZvcL";
    private static final int RFC822_TIMEZONE_FIELD = 23;

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.computeCenturyStart();
            this.serialVersionOnStream = 1;
        } else {
            this.set2DigitYearStart(this.defaultCenturyStart);
        }
        this.tokens = new ArrayList();
        try {
            this.compileFormat(this.pattern);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException("The stream pattern was invalid.");
        }
    }

    private void compileFormat(String pattern2) {
        CompiledField current = null;
        int i = 0;
        while (i < pattern2.length()) {
            char thisChar = pattern2.charAt(i);
            int field = standardChars.indexOf(thisChar);
            if (field == -1) {
                current = null;
                if (thisChar >= 'A' && thisChar <= 'Z' || thisChar >= 'a' && thisChar <= 'z') {
                    throw new IllegalArgumentException("Invalid letter " + thisChar + " encountered at character " + i + ".");
                }
                if (thisChar == '\'') {
                    int pos = pattern2.indexOf(39, i + 1);
                    if (pos == i + 1) {
                        this.tokens.add("'");
                    } else {
                        CPStringBuilder buf = new CPStringBuilder();
                        int oldPos = i + 1;
                        while (true) {
                            if (pos == -1) {
                                throw new IllegalArgumentException("Quotes starting at character " + i + " not closed.");
                            }
                            buf.append(pattern2.substring(oldPos, pos));
                            if (pos + 1 >= pattern2.length() || pattern2.charAt(pos + 1) != '\'') break;
                            buf.append('\'');
                            oldPos = pos + 2;
                            pos = pattern2.indexOf(39, pos + 2);
                        }
                        this.tokens.add(buf.toString());
                    }
                    i = pos;
                } else {
                    this.tokens.add(Character.valueOf(thisChar));
                }
            } else if (current != null && field == current.field) {
                ++current.size;
            } else {
                current = new CompiledField(field, 1, thisChar);
                this.tokens.add(current);
            }
            ++i;
        }
    }

    public String toString() {
        CPStringBuilder output = new CPStringBuilder(this.getClass().getName());
        output.append("[tokens=");
        output.append(this.tokens);
        output.append(", formatData=");
        output.append(this.formatData);
        output.append(", defaultCenturyStart=");
        output.append(this.defaultCenturyStart);
        output.append(", defaultCentury=");
        output.append(this.defaultCentury);
        output.append(", pattern=");
        output.append(this.pattern);
        output.append(", serialVersionOnStream=");
        output.append(this.serialVersionOnStream);
        output.append(", standardChars=");
        output.append(standardChars);
        output.append("]");
        return output.toString();
    }

    public SimpleDateFormat() {
        Locale locale = Locale.getDefault();
        this.calendar = new GregorianCalendar(locale);
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        this.formatData = new DateFormatSymbols(locale);
        this.pattern = String.valueOf(this.formatData.dateFormats[2]) + ' ' + this.formatData.timeFormats[2];
        this.compileFormat(this.pattern);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public SimpleDateFormat(String pattern2) {
        this(pattern2, Locale.getDefault());
    }

    public SimpleDateFormat(String pattern2, Locale locale) {
        this.calendar = new GregorianCalendar(locale);
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        this.formatData = new DateFormatSymbols(locale);
        this.compileFormat(pattern2);
        this.pattern = pattern2;
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public SimpleDateFormat(String pattern2, DateFormatSymbols formatData) {
        this.calendar = new GregorianCalendar();
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        if (formatData == null) {
            throw new NullPointerException("formatData");
        }
        this.formatData = formatData;
        this.compileFormat(pattern2);
        this.pattern = pattern2;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        String localChars = this.formatData.getLocalPatternChars();
        return this.translateLocalizedPattern(this.pattern, standardChars, localChars);
    }

    public void applyPattern(String pattern2) {
        this.tokens.clear();
        this.compileFormat(pattern2);
        this.pattern = pattern2;
    }

    public void applyLocalizedPattern(String pattern2) {
        String localChars = this.formatData.getLocalPatternChars();
        pattern2 = this.translateLocalizedPattern(pattern2, localChars, standardChars);
        this.applyPattern(pattern2);
    }

    private String translateLocalizedPattern(String pattern2, String oldChars, String newChars) {
        int len = pattern2.length();
        CPStringBuilder buf = new CPStringBuilder(len);
        boolean quoted = false;
        int i = 0;
        while (i < len) {
            int j;
            char ch = pattern2.charAt(i);
            if (ch == '\'') {
                boolean bl = quoted = !quoted;
            }
            if (!quoted && (j = oldChars.indexOf(ch)) >= 0) {
                ch = newChars.charAt(j);
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public void set2DigitYearStart(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.clear();
        this.calendar.setTime(date);
        int year = this.calendar.get(1);
        this.defaultCentury = year - year % 100;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols formatData) {
        if (formatData == null) {
            throw new NullPointerException("The supplied format data was null.");
        }
        this.formatData = formatData;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SimpleDateFormat)) {
            return false;
        }
        SimpleDateFormat sdf = (SimpleDateFormat)o;
        if (this.defaultCentury != sdf.defaultCentury) {
            return false;
        }
        if (!this.toPattern().equals(sdf.toPattern())) {
            return false;
        }
        return this.getDateFormatSymbols().equals(sdf.getDateFormatSymbols());
    }

    public int hashCode() {
        return super.hashCode() ^ this.toPattern().hashCode() ^ this.defaultCentury ^ this.getDateFormatSymbols().hashCode();
    }

    private void formatWithAttribute(Date date, FormatBuffer buffer, FieldPosition pos) {
        this.calendar.setTime(date);
        for (Object e : this.tokens) {
            if (e instanceof CompiledField) {
                CompiledField cf = (CompiledField)e;
                int beginIndex = buffer.length();
                switch (cf.getField()) {
                    case 0: {
                        buffer.append(this.formatData.eras[this.calendar.get(0)], (AttributedCharacterIterator.Attribute)DateFormat.Field.ERA);
                        break;
                    }
                    case 1: {
                        buffer.setDefaultAttribute(DateFormat.Field.YEAR);
                        if (cf.getSize() == 2) {
                            String temp = "00" + String.valueOf(this.calendar.get(1));
                            buffer.append(temp.substring(temp.length() - 2));
                            break;
                        }
                        this.withLeadingZeros(this.calendar.get(1), cf.getSize(), buffer);
                        break;
                    }
                    case 2: {
                        buffer.setDefaultAttribute(DateFormat.Field.MONTH);
                        if (cf.getSize() < 3) {
                            this.withLeadingZeros(this.calendar.get(2) + 1, cf.getSize(), buffer);
                            break;
                        }
                        if (cf.getSize() < 4) {
                            buffer.append(this.formatData.shortMonths[this.calendar.get(2)]);
                            break;
                        }
                        buffer.append(this.formatData.months[this.calendar.get(2)]);
                        break;
                    }
                    case 3: {
                        buffer.setDefaultAttribute(DateFormat.Field.DAY_OF_MONTH);
                        this.withLeadingZeros(this.calendar.get(5), cf.getSize(), buffer);
                        break;
                    }
                    case 4: {
                        buffer.setDefaultAttribute(DateFormat.Field.HOUR_OF_DAY1);
                        this.withLeadingZeros((this.calendar.get(11) + 23) % 24 + 1, cf.getSize(), buffer);
                        break;
                    }
                    case 5: {
                        buffer.setDefaultAttribute(DateFormat.Field.HOUR_OF_DAY0);
                        this.withLeadingZeros(this.calendar.get(11), cf.getSize(), buffer);
                        break;
                    }
                    case 6: {
                        buffer.setDefaultAttribute(DateFormat.Field.MINUTE);
                        this.withLeadingZeros(this.calendar.get(12), cf.getSize(), buffer);
                        break;
                    }
                    case 7: {
                        buffer.setDefaultAttribute(DateFormat.Field.SECOND);
                        this.withLeadingZeros(this.calendar.get(13), cf.getSize(), buffer);
                        break;
                    }
                    case 8: {
                        buffer.setDefaultAttribute(DateFormat.Field.MILLISECOND);
                        this.withLeadingZeros(this.calendar.get(14), cf.getSize(), buffer);
                        break;
                    }
                    case 9: {
                        buffer.setDefaultAttribute(DateFormat.Field.DAY_OF_WEEK);
                        if (cf.getSize() < 4) {
                            buffer.append(this.formatData.shortWeekdays[this.calendar.get(7)]);
                            break;
                        }
                        buffer.append(this.formatData.weekdays[this.calendar.get(7)]);
                        break;
                    }
                    case 10: {
                        buffer.setDefaultAttribute(DateFormat.Field.DAY_OF_YEAR);
                        this.withLeadingZeros(this.calendar.get(6), cf.getSize(), buffer);
                        break;
                    }
                    case 11: {
                        buffer.setDefaultAttribute(DateFormat.Field.DAY_OF_WEEK_IN_MONTH);
                        this.withLeadingZeros(this.calendar.get(8), cf.getSize(), buffer);
                        break;
                    }
                    case 12: {
                        buffer.setDefaultAttribute(DateFormat.Field.WEEK_OF_YEAR);
                        this.withLeadingZeros(this.calendar.get(3), cf.getSize(), buffer);
                        break;
                    }
                    case 13: {
                        buffer.setDefaultAttribute(DateFormat.Field.WEEK_OF_MONTH);
                        this.withLeadingZeros(this.calendar.get(4), cf.getSize(), buffer);
                        break;
                    }
                    case 14: {
                        buffer.setDefaultAttribute(DateFormat.Field.AM_PM);
                        buffer.append(this.formatData.ampms[this.calendar.get(9)]);
                        break;
                    }
                    case 15: {
                        buffer.setDefaultAttribute(DateFormat.Field.HOUR1);
                        this.withLeadingZeros((this.calendar.get(10) + 11) % 12 + 1, cf.getSize(), buffer);
                        break;
                    }
                    case 16: {
                        buffer.setDefaultAttribute(DateFormat.Field.HOUR0);
                        this.withLeadingZeros(this.calendar.get(10), cf.getSize(), buffer);
                        break;
                    }
                    case 17: {
                        buffer.setDefaultAttribute(DateFormat.Field.TIME_ZONE);
                        TimeZone zone = this.calendar.getTimeZone();
                        boolean isDST = this.calendar.get(16) != 0;
                        String zoneID = zone.getDisplayName(isDST, cf.getSize() > 3 ? 1 : 0);
                        buffer.append(zoneID);
                        break;
                    }
                    case 23: {
                        buffer.setDefaultAttribute(DateFormat.Field.TIME_ZONE);
                        int pureMinutes = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
                        String sign = pureMinutes < 0 ? "-" : "+";
                        pureMinutes = Math.abs(pureMinutes);
                        int hours = pureMinutes / 60;
                        int minutes = pureMinutes % 60;
                        buffer.append(sign);
                        this.withLeadingZeros(hours, 2, buffer);
                        this.withLeadingZeros(minutes, 2, buffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal pattern character " + cf.getCharacter());
                    }
                }
                if (pos == null || buffer.getDefaultAttribute() != pos.getFieldAttribute() && cf.getField() != pos.getField()) continue;
                pos.setBeginIndex(beginIndex);
                pos.setEndIndex(buffer.length());
                continue;
            }
            buffer.append(e.toString(), null);
        }
    }

    public StringBuffer format(Date date, StringBuffer buffer, FieldPosition pos) {
        this.formatWithAttribute(date, new StringFormatBuffer(buffer), pos);
        return buffer;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object date) throws IllegalArgumentException {
        if (date == null) {
            throw new NullPointerException("null argument");
        }
        if (!(date instanceof Date)) {
            throw new IllegalArgumentException("argument should be an instance of java.util.Date");
        }
        AttributedFormatBuffer buf = new AttributedFormatBuffer();
        this.formatWithAttribute((Date)date, buf, null);
        buf.sync();
        return new FormatCharacterIterator(buf.getBuffer().toString(), buf.getRanges(), buf.getAttributes());
    }

    private void withLeadingZeros(int value, int length, FormatBuffer buffer) {
        String valStr = String.valueOf(value);
        length -= valStr.length();
        while (length > 0) {
            buffer.append('0');
            --length;
        }
        buffer.append(valStr);
    }

    private boolean expect(String source, ParsePosition pos, char ch) {
        boolean r;
        int x = pos.getIndex();
        boolean bl = r = x < source.length() && source.charAt(x) == ch;
        if (r) {
            pos.setIndex(x + 1);
        } else {
            pos.setErrorIndex(x);
        }
        return r;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date parse(String dateStr, ParsePosition pos) {
        fmt_index = 0;
        fmt_max = this.pattern.length();
        this.calendar.clear();
        saw_timezone = false;
        quote_start = -1;
        is2DigitYear = false;
        try {
            while (fmt_index < fmt_max) {
                block54: {
                    block59: {
                        block60: {
                            block58: {
                                block56: {
                                    block57: {
                                        block55: {
                                            ch = this.pattern.charAt(fmt_index);
                                            if (ch != '\'') break block55;
                                            if (fmt_index < fmt_max - 1 && this.pattern.charAt(fmt_index + 1) == '\'') {
                                                if (!this.expect(dateStr, pos, ch)) {
                                                    return null;
                                                }
                                                ++fmt_index;
                                                break block54;
                                            } else {
                                                quote_start = quote_start < 0 ? fmt_index : -1;
                                            }
                                            break block54;
                                        }
                                        if (quote_start == -1 && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) break block56;
                                        if (quote_start != -1 || ch != ' ') break block57;
                                        save = index = pos.getIndex();
                                        if (true) ** GOTO lbl32
                                    }
                                    if (!this.expect(dateStr, pos, ch)) {
                                        return null;
                                    }
                                    break block54;
                                }
                                fmt_count = 1;
                                if (true) ** GOTO lbl40
                                do {
                                    ++index;
lbl32:
                                    // 2 sources

                                } while (index < dateStr.length() && Character.isWhitespace(dateStr.charAt(index)));
                                if (index <= save) {
                                    pos.setErrorIndex(index);
                                    return null;
                                }
                                pos.setIndex(index);
                                break block54;
                                do {
                                    ++fmt_count;
lbl40:
                                    // 2 sources

                                } while (++fmt_index < fmt_max && this.pattern.charAt(fmt_index) == ch);
                                limit_digits = false;
                                if (fmt_index < fmt_max && "GyMdkHmsSEDFwWahKzYeugAZvcL".indexOf(this.pattern.charAt(fmt_index)) >= 0) {
                                    limit_digits = true;
                                }
                                --fmt_index;
                                is_numeric = true;
                                offset = 0;
                                maybe2DigitYear = false;
                                oneBasedHour = false;
                                oneBasedHourOfDay = false;
                                set1 = null;
                                set2 = null;
                                switch (ch) {
                                    case 'd': {
                                        calendar_field = 5;
                                        break;
                                    }
                                    case 'D': {
                                        calendar_field = 6;
                                        break;
                                    }
                                    case 'F': {
                                        calendar_field = 8;
                                        break;
                                    }
                                    case 'E': {
                                        is_numeric = false;
                                        offset = 1;
                                        calendar_field = 7;
                                        set1 = this.formatData.getWeekdays();
                                        set2 = this.formatData.getShortWeekdays();
                                        break;
                                    }
                                    case 'w': {
                                        calendar_field = 3;
                                        break;
                                    }
                                    case 'W': {
                                        calendar_field = 4;
                                        break;
                                    }
                                    case 'M': {
                                        calendar_field = 2;
                                        if (fmt_count <= 2) {
                                            offset = -1;
                                            break;
                                        }
                                        is_numeric = false;
                                        set1 = this.formatData.getMonths();
                                        set2 = this.formatData.getShortMonths();
                                        break;
                                    }
                                    case 'y': {
                                        calendar_field = 1;
                                        if (fmt_count > 2) break;
                                        maybe2DigitYear = true;
                                        break;
                                    }
                                    case 'K': {
                                        calendar_field = 10;
                                        break;
                                    }
                                    case 'h': {
                                        calendar_field = 10;
                                        oneBasedHour = true;
                                        break;
                                    }
                                    case 'H': {
                                        calendar_field = 11;
                                        break;
                                    }
                                    case 'k': {
                                        calendar_field = 11;
                                        oneBasedHourOfDay = true;
                                        break;
                                    }
                                    case 'm': {
                                        calendar_field = 12;
                                        break;
                                    }
                                    case 's': {
                                        calendar_field = 13;
                                        break;
                                    }
                                    case 'S': {
                                        calendar_field = 14;
                                        break;
                                    }
                                    case 'a': {
                                        is_numeric = false;
                                        calendar_field = 9;
                                        set1 = this.formatData.getAmPmStrings();
                                        break;
                                    }
                                    case 'Z': 
                                    case 'z': {
                                        is_numeric = false;
                                        calendar_field = 15;
                                        zoneStrings = this.formatData.getZoneStrings();
                                        zoneCount = zoneStrings.length;
                                        index = pos.getIndex();
                                        found_zone = false;
                                        simpleOffset = this.computeOffset(dateStr.substring(index), pos);
                                        if (simpleOffset != null) {
                                            found_zone = true;
                                            saw_timezone = true;
                                            this.calendar.set(16, 0);
                                            offset = simpleOffset;
                                        } else {
                                            j = 0;
                                            while (j < zoneCount) {
                                                strings = zoneStrings[j];
                                                k = 0;
                                                while (k < strings.length && !dateStr.startsWith(strings[k], index)) {
                                                    ++k;
                                                }
                                                if (k != strings.length) {
                                                    found_zone = true;
                                                    saw_timezone = true;
                                                    tz = TimeZone.getTimeZone(strings[0]);
                                                    if (k == 3 || k == 4) {
                                                        this.calendar.set(16, tz.getDSTSavings());
                                                    } else {
                                                        this.calendar.set(16, 0);
                                                    }
                                                    offset = tz.getRawOffset();
                                                    pos.setIndex(index + strings[k].length());
                                                    break;
                                                }
                                                ++j;
                                            }
                                        }
                                        if (found_zone) break;
                                        pos.setErrorIndex(pos.getIndex());
                                        return null;
                                    }
                                    default: {
                                        pos.setErrorIndex(pos.getIndex());
                                        return null;
                                    }
                                }
                                index = -1;
                                if (!is_numeric) break block58;
                                this.numberFormat.setMinimumIntegerDigits(fmt_count);
                                if (maybe2DigitYear) {
                                    index = pos.getIndex();
                                }
                                n = null;
                                if (limit_digits) {
                                    origPos = pos.getIndex();
                                    pos.setIndex(0);
                                    n = this.numberFormat.parse(dateStr.substring(origPos, origPos + fmt_count), pos);
                                    pos.setIndex(origPos + pos.getIndex());
                                } else {
                                    n = this.numberFormat.parse(dateStr, pos);
                                }
                                if (pos == null || !(n instanceof Long)) {
                                    return null;
                                }
                                value = n.intValue() + offset;
                                break block59;
                            }
                            if (set1 == null) break block60;
                            index = pos.getIndex();
                            found = false;
                            i = offset;
                            if (true) ** GOTO lbl189
                        }
                        value = offset;
                        break block59;
                        do {
                            if (set1[i] != null && dateStr.toUpperCase().startsWith(set1[i].toUpperCase(), index)) {
                                found = true;
                                pos.setIndex(index + set1[i].length());
                                break;
                            }
                            ++i;
lbl189:
                            // 2 sources

                        } while (i < set1.length);
                        if (!found && set2 != null) {
                            i = offset;
                            while (i < set2.length) {
                                if (set2[i] != null && dateStr.toUpperCase().startsWith(set2[i].toUpperCase(), index)) {
                                    found = true;
                                    pos.setIndex(index + set2[i].length());
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (!found) {
                            pos.setErrorIndex(index);
                            return null;
                        }
                        value = i;
                    }
                    if (maybe2DigitYear && (digit_count = pos.getIndex() - index) == 2) {
                        is2DigitYear = true;
                        value += this.defaultCentury;
                    }
                    if (oneBasedHour && value == 12) {
                        value = 0;
                    }
                    if (oneBasedHourOfDay && value == 24) {
                        value = 0;
                    }
                    this.calendar.set(calendar_field, value);
                }
                ++fmt_index;
            }
            if (is2DigitYear) {
                year = this.calendar.get(1);
                if (this.calendar.getTime().compareTo(this.defaultCenturyStart) < 0) {
                    this.calendar.set(1, year + 100);
                }
            }
            if (!saw_timezone) {
                this.calendar.clear(16);
                this.calendar.clear(15);
            }
            return this.calendar.getTime();
        }
        catch (IllegalArgumentException v0) {
            pos.setErrorIndex(pos.getIndex());
            return null;
        }
    }

    private Integer computeOffset(String zoneString, ParsePosition pos) {
        Pattern pattern2 = Pattern.compile("(GMT)?([+-])([012])?([0-9]):?([0-9]{2})");
        Matcher matcher = pattern2.matcher(zoneString);
        boolean hasAll = matcher.lookingAt();
        try {
            matcher.group(2);
            matcher.group(4);
            matcher.group(5);
        }
        catch (IllegalStateException illegalStateException) {
            hasAll = false;
        }
        if (hasAll) {
            int sign = matcher.group(2).equals("+") ? 1 : -1;
            int hour = Integer.parseInt(matcher.group(4));
            if (!matcher.group(3).equals("")) {
                hour += Integer.parseInt(matcher.group(3)) * 10;
            }
            int minutes = Integer.parseInt(matcher.group(5));
            if (hour > 23) {
                return null;
            }
            int offset = sign * (hour * 60 + minutes) * 60000;
            pos.setIndex(pos.getIndex() + matcher.end());
            return offset;
        }
        if (zoneString.startsWith("GMT")) {
            pos.setIndex(pos.getIndex() + 3);
            return 0;
        }
        return null;
    }

    private void computeCenturyStart() {
        int year = this.calendar.get(1);
        this.calendar.set(1, year - 80);
        this.set2DigitYearStart(this.calendar.getTime());
    }

    public Object clone() {
        SimpleDateFormat clone = (SimpleDateFormat)super.clone();
        clone.setDateFormatSymbols((DateFormatSymbols)this.formatData.clone());
        clone.set2DigitYearStart((Date)this.defaultCenturyStart.clone());
        return clone;
    }

    private class CompiledField {
        int field;
        int size;
        private char character;

        public CompiledField(int f, int s, char c) {
            this.field = f;
            this.size = s;
            this.character = c;
        }

        public int getField() {
            return this.field;
        }

        public int getSize() {
            return this.size;
        }

        public char getCharacter() {
            return this.character;
        }

        public String toString() {
            CPStringBuilder builder = new CPStringBuilder(this.getClass().getName());
            builder.append("[field=");
            builder.append(this.field);
            builder.append(", size=");
            builder.append(this.size);
            builder.append(", character=");
            builder.append(this.character);
            builder.append("]");
            return builder.toString();
        }
    }
}

