/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.reflect.FieldSignatureParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Field
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private String name;
    private int offset;
    private Class type;
    static final int FIELD_MODIFIERS = 223;

    Field() {
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public native String getName();

    private native int getModifiersInternal();

    @Override
    public int getModifiers() {
        return this.getModifiersInternal() & 0xDF;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiersInternal() & 0x1000) != 0;
    }

    public boolean isEnumConstant() {
        return (this.getModifiersInternal() & 0x4000) != 0;
    }

    public native Class<?> getType();

    public boolean equals(Object fld) {
        if (!(fld instanceof Field)) {
            return false;
        }
        Field f = (Field)fld;
        return this.declaringClass == f.declaringClass && this.offset == f.offset;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        int mods = this.getModifiers();
        if (mods != 0) {
            Modifier.toString(mods, sbuf);
            sbuf.append(' ');
        }
        Method.appendClassName(sbuf, this.getType());
        sbuf.append(' ');
        Method.appendClassName(sbuf, this.getDeclaringClass());
        sbuf.append('.');
        sbuf.append(this.getName());
        return sbuf.toString();
    }

    public String toGenericString() {
        StringBuilder sb = new StringBuilder(64);
        Modifier.toString(this.getModifiers(), sb).append(' ');
        sb.append(this.getGenericType()).append(' ');
        sb.append(this.getDeclaringClass().getName()).append('.');
        sb.append(this.getName());
        return sb.toString();
    }

    public Object get(Object obj) throws IllegalAccessException {
        return this.get(null, obj);
    }

    public boolean getBoolean(Object obj) throws IllegalAccessException {
        return this.getBoolean(null, obj);
    }

    public byte getByte(Object obj) throws IllegalAccessException {
        return this.getByte(null, obj);
    }

    public char getChar(Object obj) throws IllegalAccessException {
        return this.getChar(null, obj);
    }

    public short getShort(Object obj) throws IllegalAccessException {
        return this.getShort(null, obj);
    }

    public int getInt(Object obj) throws IllegalAccessException {
        return this.getInt(null, obj);
    }

    public long getLong(Object obj) throws IllegalAccessException {
        return this.getLong(null, obj);
    }

    public float getFloat(Object obj) throws IllegalAccessException {
        return this.getFloat(null, obj);
    }

    public double getDouble(Object obj) throws IllegalAccessException {
        return this.getDouble(null, obj);
    }

    private native boolean getBoolean(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native char getChar(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native byte getByte(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native short getShort(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native int getInt(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native long getLong(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native float getFloat(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native double getDouble(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native Object get(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    public void set(Object object, Object value) throws IllegalAccessException {
        this.set(null, object, value);
    }

    public void setBoolean(Object obj, boolean b) throws IllegalAccessException {
        this.setBoolean(null, obj, b, true);
    }

    public void setByte(Object obj, byte b) throws IllegalAccessException {
        this.setByte(null, obj, b, true);
    }

    public void setChar(Object obj, char c) throws IllegalAccessException {
        this.setChar(null, obj, c, true);
    }

    public void setShort(Object obj, short s) throws IllegalAccessException {
        this.setShort(null, obj, s, true);
    }

    public void setInt(Object obj, int i) throws IllegalAccessException {
        this.setInt(null, obj, i, true);
    }

    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(null, obj, l, true);
    }

    public void setFloat(Object obj, float f) throws IllegalAccessException {
        this.setFloat(null, obj, f, true);
    }

    public void setDouble(Object obj, double d) throws IllegalAccessException {
        this.setDouble(null, obj, d, true);
    }

    public Type getGenericType() {
        String signature = this.getSignature();
        if (signature == null) {
            return this.getType();
        }
        FieldSignatureParser p = new FieldSignatureParser(this.getDeclaringClass(), signature);
        return p.getFieldType();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annoClass) {
        Annotation[] annos = this.getDeclaredAnnotations();
        int i = 0;
        while (i < annos.length) {
            if (annos[i].annotationType() == annoClass) {
                return (T)annos[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] result = this.getDeclaredAnnotationsInternal();
        if (result == null) {
            result = new Annotation[]{};
        }
        return result;
    }

    private native Annotation[] getDeclaredAnnotationsInternal();

    private native String getSignature();

    native void setByte(Class var1, Object var2, byte var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setShort(Class var1, Object var2, short var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setInt(Class var1, Object var2, int var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setLong(Class var1, Object var2, long var3, boolean var5) throws IllegalArgumentException, IllegalAccessException;

    native void setFloat(Class var1, Object var2, float var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setDouble(Class var1, Object var2, double var3, boolean var5) throws IllegalArgumentException, IllegalAccessException;

    native void setChar(Class var1, Object var2, char var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setBoolean(Class var1, Object var2, boolean var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void set(Class var1, Object var2, Object var3, Class var4, boolean var5) throws IllegalArgumentException, IllegalAccessException;

    private void set(Class caller, Object object, Object value) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = this.getType();
        if (!type.isPrimitive()) {
            this.set(caller, object, value, type, true);
        } else if (value instanceof Byte) {
            this.setByte(caller, object, (Byte)value, true);
        } else if (value instanceof Short) {
            this.setShort(caller, object, (Short)value, true);
        } else if (value instanceof Integer) {
            this.setInt(caller, object, (Integer)value, true);
        } else if (value instanceof Long) {
            this.setLong(caller, object, (Long)value, true);
        } else if (value instanceof Float) {
            this.setFloat(caller, object, ((Float)value).floatValue(), true);
        } else if (value instanceof Double) {
            this.setDouble(caller, object, (Double)value, true);
        } else if (value instanceof Character) {
            this.setChar(caller, object, ((Character)value).charValue(), true);
        } else if (value instanceof Boolean) {
            this.setBoolean(caller, object, (Boolean)value, true);
        } else {
            throw new IllegalArgumentException();
        }
    }
}

