/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

public abstract class DataBuffer {
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_USHORT = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DOUBLE = 5;
    public static final int TYPE_UNDEFINED = 32;
    protected int dataType;
    protected int banks = 1;
    protected int offset;
    protected int size;
    protected int[] offsets;

    protected DataBuffer(int dataType, int size) {
        this(dataType, size, 1);
    }

    protected DataBuffer(int dataType, int size, int numBanks) {
        this(dataType, size, numBanks, 0);
    }

    protected DataBuffer(int dataType, int size, int numBanks, int offset) {
        this.banks = numBanks;
        this.dataType = dataType;
        this.size = size;
        this.offset = offset;
        this.offsets = new int[numBanks];
        int i = 0;
        while (i < numBanks) {
            this.offsets[i] = offset;
            ++i;
        }
    }

    protected DataBuffer(int dataType, int size, int numBanks, int[] offsets) {
        if (numBanks != offsets.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.dataType = dataType;
        this.size = size;
        this.banks = numBanks;
        this.offsets = offsets;
        this.offset = offsets[0];
    }

    public static int getDataTypeSize(int dataType) {
        switch (dataType) {
            case 0: {
                return 8;
            }
            case 1: 
            case 2: {
                return 16;
            }
            case 3: 
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    public int[] getOffsets() {
        if (this.offsets == null) {
            this.offsets = new int[1];
            this.offsets[0] = this.offset;
        }
        return this.offsets;
    }

    public int getNumBanks() {
        return this.banks;
    }

    public int getElem(int i) {
        return this.getElem(0, i);
    }

    public abstract int getElem(int var1, int var2);

    public void setElem(int i, int val) {
        this.setElem(0, i, val);
    }

    public abstract void setElem(int var1, int var2, int var3);

    public float getElemFloat(int i) {
        return this.getElem(i);
    }

    public float getElemFloat(int bank, int i) {
        return this.getElem(bank, i);
    }

    public void setElemFloat(int i, float val) {
        this.setElem(i, (int)val);
    }

    public void setElemFloat(int bank, int i, float val) {
        this.setElem(bank, i, (int)val);
    }

    public double getElemDouble(int i) {
        return this.getElem(i);
    }

    public double getElemDouble(int bank, int i) {
        return this.getElem(bank, i);
    }

    public void setElemDouble(int i, double val) {
        this.setElem(i, (int)val);
    }

    public void setElemDouble(int bank, int i, double val) {
        this.setElem(bank, i, (int)val);
    }
}

