/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.java.awt.AWTUtilities;
import gnu.java.awt.peer.GLightweightPeer;
import gnu.java.awt.peer.headless.HeadlessToolkit;
import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AWTPermission;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.AWTEventListener;
import java.awt.event.AWTEventListenerProxy;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Toolkit {
    private static String default_toolkit_name = Configuration.default_awt_peer_toolkit;
    private static Toolkit toolkit;
    private static Properties props;
    protected final Map<String, Object> desktopProperties = new Hashtable<String, Object>();
    protected final PropertyChangeSupport desktopPropsSupport = new PropertyChangeSupport(this);
    AWTEventListenerProxy[] awtEventListeners = new AWTEventListenerProxy[0];
    private GLightweightPeer lightweightPeer;

    static {
        props = new Properties();
    }

    protected abstract DesktopPeer createDesktopPeer(Desktop var1) throws HeadlessException;

    protected abstract ButtonPeer createButton(Button var1);

    protected abstract TextFieldPeer createTextField(TextField var1);

    protected abstract LabelPeer createLabel(Label var1);

    protected abstract ListPeer createList(List var1);

    protected abstract CheckboxPeer createCheckbox(Checkbox var1);

    protected abstract ScrollbarPeer createScrollbar(Scrollbar var1);

    protected abstract ScrollPanePeer createScrollPane(ScrollPane var1);

    protected abstract TextAreaPeer createTextArea(TextArea var1);

    protected abstract ChoicePeer createChoice(Choice var1);

    protected abstract FramePeer createFrame(Frame var1);

    protected abstract CanvasPeer createCanvas(Canvas var1);

    protected abstract PanelPeer createPanel(Panel var1);

    protected abstract WindowPeer createWindow(Window var1);

    protected abstract DialogPeer createDialog(Dialog var1);

    protected abstract MenuBarPeer createMenuBar(MenuBar var1);

    protected abstract MenuPeer createMenu(Menu var1);

    protected abstract PopupMenuPeer createPopupMenu(PopupMenu var1);

    protected abstract MenuItemPeer createMenuItem(MenuItem var1);

    protected MouseInfoPeer getMouseInfoPeer() {
        throw new UnsupportedOperationException("No mouse info peer.");
    }

    protected abstract FileDialogPeer createFileDialog(FileDialog var1);

    protected abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1);

    protected LightweightPeer createComponent(Component target) {
        if (this.lightweightPeer == null) {
            this.lightweightPeer = new GLightweightPeer();
        }
        return this.lightweightPeer;
    }

    protected abstract FontPeer getFontPeer(String var1, int var2);

    protected void loadSystemColors(int[] systemColors) {
        systemColors[0] = -16753572;
        systemColors[1] = -16777088;
        systemColors[2] = -1;
        systemColors[3] = -4144960;
        systemColors[4] = -8355712;
        systemColors[5] = -4144960;
        systemColors[6] = -4144960;
        systemColors[7] = -1;
        systemColors[8] = -16777216;
        systemColors[9] = -16777216;
        systemColors[10] = -4144960;
        systemColors[11] = -16777216;
        systemColors[12] = -4144960;
        systemColors[13] = -16777216;
        systemColors[14] = -16777072;
        systemColors[15] = -1;
        systemColors[16] = -8355712;
        systemColors[17] = -4144960;
        systemColors[18] = -16777216;
        systemColors[19] = -1;
        systemColors[20] = -2039584;
        systemColors[21] = -8355712;
        systemColors[22] = -16777216;
        systemColors[23] = -2039584;
        systemColors[24] = -2039808;
        systemColors[25] = -16777216;
    }

    public void setDynamicLayout(boolean dynamic) {
    }

    protected boolean isDynamicLayoutSet() {
        return false;
    }

    public boolean isDynamicLayoutActive() {
        return false;
    }

    public abstract Dimension getScreenSize();

    public abstract int getScreenResolution();

    public Insets getScreenInsets(GraphicsConfiguration gc) {
        return new Insets(0, 0, 0, 0);
    }

    public abstract ColorModel getColorModel();

    public abstract String[] getFontList();

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract void sync();

    public static synchronized Toolkit getDefaultToolkit() {
        if (toolkit != null) {
            return toolkit;
        }
        String toolkit_name = SystemProperties.getProperty("awt.toolkit", default_toolkit_name);
        try {
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
            Class<?> cls = Class.forName(toolkit_name, true, cl);
            Object obj = cls.newInstance();
            if (!(obj instanceof Toolkit)) {
                throw new AWTError(String.valueOf(toolkit_name) + " is not a subclass of " + "java.awt.Toolkit");
            }
            toolkit = (Toolkit)obj;
            Toolkit.initAccessibility();
            return toolkit;
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t) {
            if (GraphicsEnvironment.isHeadless()) {
                toolkit = new HeadlessToolkit();
                return toolkit;
            }
            AWTError e = new AWTError("Cannot load AWT toolkit: " + toolkit_name);
            throw (AWTError)e.initCause(t);
        }
    }

    public abstract Image getImage(String var1);

    public abstract Image getImage(URL var1);

    public abstract Image createImage(String var1);

    public abstract Image createImage(URL var1);

    public abstract boolean prepareImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract int checkImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract Image createImage(ImageProducer var1);

    public Image createImage(byte[] data) {
        return this.createImage(data, 0, data.length);
    }

    public abstract Image createImage(byte[] var1, int var2, int var3);

    public abstract PrintJob getPrintJob(Frame var1, String var2, Properties var3);

    public PrintJob getPrintJob(Frame frame, String title, JobAttributes jobAttr, PageAttributes pageAttr) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPrintJobAccess();
        }
        return null;
    }

    public abstract void beep();

    public abstract Clipboard getSystemClipboard();

    public Clipboard getSystemSelection() {
        return null;
    }

    public int getMenuShortcutKeyMask() {
        return 2;
    }

    public boolean getLockingKeyState(int keyCode) {
        if (AWTUtilities.isValidKey(keyCode)) {
            throw new UnsupportedOperationException("cannot get locking state of key code " + keyCode);
        }
        throw new IllegalArgumentException("invalid key code " + keyCode);
    }

    public void setLockingKeyState(int keyCode, boolean on) {
        if (keyCode != 20 && keyCode != 144 && keyCode != 145) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException();
    }

    protected static Container getNativeContainer(Component component) {
        component = component.getParent();
        while (true) {
            if (component == null) {
                return null;
            }
            if (!(component instanceof Container)) {
                component = component.getParent();
                continue;
            }
            if (!(component.getPeer() instanceof LightweightPeer)) break;
            component = component.getParent();
        }
        return (Container)component;
    }

    public Cursor createCustomCursor(Image cursor, Point hotSpot, String name) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("No custom cursor in an headless graphics environment.");
        }
        return null;
    }

    public Dimension getBestCursorSize(int preferredWidth, int preferredHeight) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("No best cursor size in an headless graphics environment.");
        }
        return new Dimension(0, 0);
    }

    public int getMaximumCursorColors() {
        return 0;
    }

    public boolean isFrameStateSupported(int state) {
        return false;
    }

    public static String getProperty(String key, String def) {
        return props.getProperty(key, def);
    }

    public final EventQueue getSystemEventQueue() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkAwtEventQueueAccess();
        }
        return this.getSystemEventQueueImpl();
    }

    protected abstract EventQueue getSystemEventQueueImpl();

    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1);

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> recognizer, DragSource ds, Component comp, int actions, DragGestureListener l) {
        return null;
    }

    public final Object getDesktopProperty(String propertyName) {
        return this.desktopProperties.get(propertyName);
    }

    protected final void setDesktopProperty(String name, Object newValue) {
        Object oldValue = this.getDesktopProperty(name);
        this.desktopProperties.put(name, newValue);
        this.desktopPropsSupport.firePropertyChange(name, oldValue, newValue);
    }

    protected Object lazilyLoadDesktopProperty(String name) {
        return null;
    }

    protected void initializeDesktopProperties() {
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.desktopPropsSupport.addPropertyChangeListener(name, pcl);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.desktopPropsSupport.removePropertyChangeListener(name, pcl);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.desktopPropsSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String name) {
        return this.desktopPropsSupport.getPropertyChangeListeners(name);
    }

    public void addAWTEventListener(AWTEventListener listener, long eventMask) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkPermission(new AWTPermission("listenToAllAWTEvents"));
        }
        boolean found = false;
        int i = 0;
        while (i < this.awtEventListeners.length) {
            AWTEventListenerProxy proxy = this.awtEventListeners[i];
            if (proxy.getListener() == listener) {
                AWTEventListenerProxy newProxy;
                found = true;
                this.awtEventListeners[i] = newProxy = new AWTEventListenerProxy(proxy.getEventMask() | eventMask, listener);
                break;
            }
            ++i;
        }
        if (!found) {
            AWTEventListenerProxy proxy = new AWTEventListenerProxy(eventMask, listener);
            AWTEventListenerProxy[] newArray = new AWTEventListenerProxy[this.awtEventListeners.length + 1];
            System.arraycopy(this.awtEventListeners, 0, newArray, 0, this.awtEventListeners.length);
            newArray[newArray.length - 1] = proxy;
            this.awtEventListeners = newArray;
        }
    }

    public void removeAWTEventListener(AWTEventListener listener) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkPermission(new AWTPermission("listenToAllAWTEvents"));
        }
        int index = -1;
        int i = 0;
        while (i < this.awtEventListeners.length) {
            AWTEventListenerProxy proxy = this.awtEventListeners[i];
            if (proxy.getListener() == listener) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            AWTEventListenerProxy[] newArray = new AWTEventListenerProxy[this.awtEventListeners.length - 1];
            if (index > 0) {
                System.arraycopy(this.awtEventListeners, 0, newArray, 0, index);
            }
            if (index < this.awtEventListeners.length - 1) {
                System.arraycopy(this.awtEventListeners, index + 1, newArray, index, this.awtEventListeners.length - index - 1);
            }
            this.awtEventListeners = newArray;
        }
    }

    public AWTEventListener[] getAWTEventListeners() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkPermission(new AWTPermission("listenToAllAWTEvents"));
        }
        AWTEventListener[] copy = new AWTEventListener[this.awtEventListeners.length];
        System.arraycopy(this.awtEventListeners, 0, copy, 0, this.awtEventListeners.length);
        return copy;
    }

    public AWTEventListener[] getAWTEventListeners(long mask) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkPermission(new AWTPermission("listenToAllAWTEvents"));
        }
        ArrayList<AWTEventListenerProxy> l = new ArrayList<AWTEventListenerProxy>(this.awtEventListeners.length);
        int i = 0;
        while (i < this.awtEventListeners.length) {
            if ((this.awtEventListeners[i].getEventMask() & mask) != 0L) {
                l.add(this.awtEventListeners[i]);
            }
            ++i;
        }
        return l.toArray(new AWTEventListener[l.size()]);
    }

    void globalDispatchEvent(AWTEvent ev) {
        int i = 0;
        while (i < this.awtEventListeners.length) {
            AWTEventListenerProxy proxy = this.awtEventListeners[i];
            if ((proxy.getEventMask() & AWTEvent.eventIdToMask(ev.getID())) != 0L) {
                proxy.eventDispatched(ev);
            }
            ++i;
        }
    }

    public abstract Map<TextAttribute, ?> mapInputMethodHighlight(InputMethodHighlight var1);

    public abstract boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType var1);

    public abstract boolean isModalityTypeSupported(Dialog.ModalityType var1);

    private static void initAccessibility() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String classes;
                String readerPresent;
                String magPresent;
                FileInputStream in;
                File propsFile;
                Properties props = new Properties();
                String sep = File.separator;
                try {
                    propsFile = new File(String.valueOf(System.getProperty("user.home")) + sep + ".accessibility.properties");
                    in = new FileInputStream(propsFile);
                    props.load(in);
                    in.close();
                }
                catch (Exception exception) {}
                if (props.size() == 0) {
                    try {
                        propsFile = new File(String.valueOf(System.getProperty("gnu.classpath.home.url")) + sep + "accessibility.properties");
                        in = new FileInputStream(propsFile);
                        props.load(in);
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                if ((magPresent = SystemProperties.getProperty("javax.accessibility.screen_magnifier_present")) == null && (magPresent = props.getProperty("screen_magnifier_present")) != null) {
                    SystemProperties.setProperty("javax.accessibility.screen_magnifier_present", magPresent);
                }
                if ((readerPresent = SystemProperties.getProperty("javax.accessibility.screen_reader_present")) == null && (readerPresent = props.getProperty("screen_reader_present")) != null) {
                    SystemProperties.setProperty("javax.accessibility.screen_reader_present", readerPresent);
                }
                if ((classes = SystemProperties.getProperty("javax.accessibility.assistive_technologies")) == null && (classes = props.getProperty("assistive_technologies")) != null) {
                    SystemProperties.setProperty("javax.accessibility.assistive_technologies", classes);
                }
                if (classes != null) {
                    ClassLoader cl = ClassLoader.getSystemClassLoader();
                    StringTokenizer tokenizer = new StringTokenizer(classes, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String className = tokenizer.nextToken();
                        try {
                            Class<?> atClass = cl.loadClass(className);
                            atClass.newInstance();
                        }
                        catch (ClassNotFoundException ex) {
                            AWTError err = new AWTError("Assistive Technology class not found: " + className);
                            err.initCause(ex);
                            throw err;
                        }
                        catch (InstantiationException ex) {
                            AWTError err = new AWTError("Assistive Technology class cannot be instantiated: " + className);
                            err.initCause(ex);
                            throw err;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            AWTError err = new AWTError("Assistive Technology class cannot be accessed: " + className);
                            err.initCause(err);
                            throw err;
                        }
                    }
                }
                return null;
            }
        });
    }
}

