/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

final class MessageNode
extends TemplateNode {
    static final Logger logger = Logger.getLogger("gnu.xml.transform");
    final boolean terminate;

    MessageNode(boolean terminate) {
        this.terminate = terminate;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        MessageNode ret = new MessageNode(this.terminate);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        if (this.children != null) {
            Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
            DocumentFragment fragment = doc.createDocumentFragment();
            this.children.apply(stylesheet, mode, context, pos, len, fragment, null);
            String message = Expr.stringValue(fragment);
            logger.info(message);
            if (this.terminate) {
                stylesheet.terminated = true;
            }
        }
        if (this.next != null && !this.terminate) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public String toString() {
        CPStringBuilder buf = new CPStringBuilder("message");
        if (this.terminate) {
            buf.append('[');
            buf.append("terminate");
            buf.append(']');
        }
        return buf.toString();
    }
}

