/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomImpl;
import gnu.xml.dom.ImplementationList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.DOMImplementationSource;

public class ImplementationSource
implements DOMImplementationSource {
    private static final String DIGITS = "1234567890";
    private static final DOMImplementation[] implementations;

    static {
        ArrayList<DomImpl> acc = new ArrayList<DomImpl>();
        acc.add(new DomImpl());
        try {
            Class<?> t = Class.forName("gnu.xml.libxmlj.dom.GnomeDocumentBuilder");
            acc.add((DomImpl)t.newInstance());
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        implementations = new DOMImplementation[acc.size()];
        acc.toArray(implementations);
    }

    public DOMImplementation getDOMImplementation(String features) {
        List available = this.getImplementations(features);
        if (available.isEmpty()) {
            return null;
        }
        return (DOMImplementation)available.get(0);
    }

    public DOMImplementationList getDOMImplementationList(String features) {
        List available = this.getImplementations(features);
        return new ImplementationList(available);
    }

    private final List getImplementations(String features) {
        ArrayList<DOMImplementation> available = new ArrayList<DOMImplementation>(Arrays.asList(implementations));
        for (String feature : this.parseFeatures(features)) {
            String version = null;
            int si = feature.indexOf(32);
            if (si != -1) {
                version = feature.substring(si + 1);
                feature = feature.substring(0, si);
            }
            Iterator j = available.iterator();
            while (j.hasNext()) {
                DOMImplementation impl = (DOMImplementation)j.next();
                if (impl.hasFeature(feature, version)) continue;
                j.remove();
            }
        }
        return available;
    }

    final List parseFeatures(String features) {
        ArrayList<String> list2 = new ArrayList<String>();
        int pos = 0;
        int start = 0;
        int len = features.length();
        while (pos < len) {
            char c = features.charAt(pos);
            if (c == ' ' && pos + 1 < len && DIGITS.indexOf(features.charAt(pos + 1)) == -1) {
                list2.add(this.getFeature(features, start, pos));
                start = pos + 1;
            }
            ++pos;
        }
        if (pos > start) {
            list2.add(this.getFeature(features, start, len));
        }
        return list2;
    }

    final String getFeature(String features, int start, int end) {
        if (features.length() > 0 && features.charAt(start) == '+') {
            return features.substring(start + 1, end);
        }
        return features.substring(start, end);
    }
}

