/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CertificateStatusType;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateStatusRequest
extends Extension.Value
implements Iterable<byte[]> {
    private ByteBuffer buffer;

    public CertificateStatusRequest(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public CertificateStatusRequest(CertificateStatusType type, List<byte[]> responderIdList, byte[] requestExtensions) {
        if (type != CertificateStatusType.OCSP) {
            throw new IllegalArgumentException();
        }
        int length = 3;
        int idsLength = 0;
        for (byte[] responderId : responderIdList) {
            length += 2 + responderId.length;
            idsLength += 2 + responderId.length;
        }
        this.buffer = ByteBuffer.allocate(length += 2 + requestExtensions.length);
        this.buffer.put((byte)1);
        this.buffer.putShort((short)idsLength);
        for (byte[] responderId : responderIdList) {
            this.buffer.putShort((short)responderId.length).put(responderId);
        }
        this.buffer.putShort((short)requestExtensions.length);
        this.buffer.put(requestExtensions);
        this.buffer.rewind();
    }

    @Override
    public int length() {
        int l = 3 + (this.buffer.getShort(1) & 0xFFFF);
        return l + (this.buffer.getShort(l) & 0xFFFF) + 2;
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public CertificateStatusType statusType() {
        int x = this.buffer.get(0) & 0xFF;
        if (x == 1) {
            return CertificateStatusType.OCSP;
        }
        throw new IllegalArgumentException("invalid type: " + x);
    }

    public int size() {
        int len = this.buffer.getShort(1) & 0xFFFF;
        int n = 0;
        int i = 3;
        while (i < len) {
            short l = this.buffer.getShort(i);
            i += l + 2;
            ++n;
        }
        return n;
    }

    public byte[] responderId(int index) {
        int len = this.buffer.getShort(1) & 0xFFFF;
        int n = 0;
        int i = 3;
        while (i < len && n <= index) {
            int l = this.buffer.getShort(i) & 0xFFFF;
            if (n == index) {
                byte[] b = new byte[l];
                ((ByteBuffer)this.buffer.duplicate().position(i + 2)).get(b);
                return b;
            }
            i += l + 2;
            ++n;
        }
        throw new IndexOutOfBoundsException();
    }

    public byte[] requestExtensions() {
        int l = 2 + (this.buffer.getShort(0) & 0xFFFF);
        int ll = this.buffer.getShort(l) & 0xFFFF;
        byte[] b = new byte[ll];
        ((ByteBuffer)this.buffer.duplicate().position(ll + 2)).get(b);
        return b;
    }

    public void setStatusType(CertificateStatusType type) {
        this.buffer.put(0, (byte)type.value);
    }

    public void setRequestIdListLength(int newLength) {
        if (newLength < 0 || newLength > 65535) {
            throw new IllegalArgumentException("length out of range");
        }
        this.buffer.putShort(1, (short)newLength);
    }

    public void putRequestId(int index, byte[] id) {
        if (id.length > 65535) {
            throw new IllegalArgumentException("request ID too large");
        }
        int len = this.buffer.getShort(1) & 0xFFFF;
        int n = 0;
        int i = 3;
        while (i < len && n < index) {
            int l = this.buffer.getShort(i) & 0xFFFF;
            i += l + 2;
            ++n;
        }
        if (n < index) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putShort(i, (short)id.length);
        ((ByteBuffer)this.buffer.duplicate().position(i)).put(id);
    }

    public void setRequestExtensions(int index, byte[] ext) {
        if (ext.length > 65535) {
            throw new IllegalArgumentException("exceptions too large");
        }
        int off = 3 + (this.buffer.getShort(1) & 0xFFFF);
        this.buffer.putShort(off, (short)ext.length);
        ((ByteBuffer)this.buffer.duplicate().position(off + 2)).put(ext);
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new ResponderIdIterator();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  status_type = ");
        out.print((Object)this.statusType());
        out.println(";");
        String subprefix = "    ";
        if (prefix != null) {
            subprefix = String.valueOf(prefix) + subprefix;
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  responder_id_list = {");
        for (byte[] b : this) {
            out.print(Util.hexDump(b, subprefix));
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  };");
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  request_extensions =");
        out.print(Util.hexDump(this.requestExtensions(), subprefix));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} CertificateStatus;");
        return str.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResponderIdIterator
    implements Iterator<byte[]> {
        private int index = 0;

        @Override
        public byte[] next() throws NoSuchElementException {
            try {
                return CertificateStatusRequest.this.responderId(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < CertificateStatusRequest.this.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

