/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGException;

public class PNGHeader
extends PNGChunk {
    private int width;
    private int height;
    private int depth;
    private int colorType;
    private int compression;
    private int filter;
    private int interlace;
    public static final int INTERLACE_NONE = 0;
    public static final int INTERLACE_ADAM7 = 1;
    public static final int GRAYSCALE = 0;
    public static final int RGB = 2;
    public static final int INDEXED = 3;
    public static final int GRAYSCALE_WITH_ALPHA = 4;
    public static final int RGB_WITH_ALPHA = 6;

    protected PNGHeader(int type, byte[] data, int crc) throws PNGException {
        super(type, data, crc);
        if (data.length < 13) {
            throw new PNGException("Unexpectedly short header chunk. (" + data.length + " bytes)");
        }
        this.width = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        this.height = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        this.depth = data[8] & 0xFF;
        this.colorType = data[9] & 0xFF;
        this.compression = data[10] & 0xFF;
        this.filter = data[11] & 0xFF;
        this.interlace = data[12] & 0xFF;
    }

    public PNGHeader(int width, int height, int depth, int colorType, boolean interlace) {
        super(1229472850);
        this.data = new byte[13];
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.filter = 0;
        this.compression = 0;
        this.colorType = colorType;
        this.interlace = interlace ? 1 : 0;
        byte[] a = PNGHeader.getInt(width);
        byte[] b = PNGHeader.getInt(height);
        this.data[0] = a[0];
        this.data[1] = a[1];
        this.data[2] = a[2];
        this.data[3] = a[3];
        this.data[4] = b[0];
        this.data[5] = b[1];
        this.data[6] = b[2];
        this.data[7] = b[3];
        this.data[8] = (byte)depth;
        this.data[9] = (byte)colorType;
        this.data[10] = (byte)this.compression;
        this.data[11] = (byte)this.filter;
        this.data[12] = (byte)this.interlace;
    }

    public boolean isValidChunk() {
        if (!super.isValidChunk()) {
            return false;
        }
        if (this.width == 0 || this.height == 0) {
            return false;
        }
        if ((this.colorType & 0xFFFFFFF8) != 0 || this.colorType == 5 || this.colorType == 1) {
            return false;
        }
        if (this.depth != 1 && this.depth != 2 && this.depth != 4 && this.depth != 8 && this.depth != 16) {
            return false;
        }
        if (this.colorType == 3 && this.depth == 16) {
            return false;
        }
        if ((this.colorType == 2 || this.colorType == 4 || this.colorType == 6) && this.depth < 8) {
            return false;
        }
        if (this.compression != 0 || this.filter != 0) {
            return false;
        }
        return (this.interlace & 0xFFFFFFFE) == 0;
    }

    public boolean isIndexed() {
        return this.colorType == 3;
    }

    public boolean isGrayscale() {
        return this.colorType == 0 || this.colorType == 4;
    }

    public int getColorType() {
        return this.colorType;
    }

    public boolean isInterlaced() {
        return this.interlace != 0;
    }

    public int bytesPerPixel() {
        switch (this.colorType) {
            case 4: {
                return this.depth * 2 >> 3;
            }
            case 2: {
                return this.depth * 3 >> 3;
            }
            case 6: {
                return this.depth * 4 >> 3;
            }
        }
        int i = this.depth >> 3;
        if (i > 0) {
            return i;
        }
        return 1;
    }

    public int getScanlineStride() {
        long nBits = 0L;
        switch (this.colorType) {
            case 0: {
                nBits = this.width * this.depth;
                break;
            }
            case 2: {
                nBits = this.width * this.depth * 3;
                break;
            }
            case 3: {
                nBits = this.depth * this.width;
                break;
            }
            case 4: {
                nBits = this.depth * this.width * 2;
                break;
            }
            case 6: {
                nBits = this.depth * this.width * 4;
            }
        }
        if ((nBits & 7L) != 0L) {
            nBits += 8L - (nBits & 7L);
        }
        return (int)(nBits >> 3);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        return "Header Chunk. Image width:" + this.width + " height:" + this.height + " depth:" + this.depth + " color type:" + this.colorType + " compression type:" + this.compression + " filter type:" + this.filter + " interlace:" + this.interlace;
    }
}

