/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGException;
import java.awt.color.ColorSpace;

public class PNGGamma
extends PNGChunk {
    private double gamma;

    protected PNGGamma(int type, byte[] data, int crc) throws PNGException {
        super(type, data, crc);
        if (data.length < 4) {
            throw new PNGException("Unexpectedly short time chunk. (" + data.length + " bytes)");
        }
        long g = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        this.gamma = g;
        this.gamma = 100000.0 / this.gamma;
    }

    public PNGGamma(double g) {
        super(1732332865);
        this.data = new byte[4];
        this.gamma = g;
        long tmp = (long)(100000.0 / this.gamma);
        this.data[0] = (byte)((tmp & 0xFFFFFFFFFF000000L) >> 24);
        this.data[1] = (byte)((tmp & 0xFF0000L) >> 16);
        this.data[2] = (byte)((tmp & 0xFF00L) >> 8);
        this.data[3] = (byte)(tmp & 0xFFL);
    }

    public ColorSpace getColorSpace(boolean grayscale) {
        return null;
    }

    public String toString() {
        return "PNG Gamma chunk, value: " + this.gamma;
    }
}

