/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.java.security.sig.rsa.EME_PKCS1_V1_5;
import gnu.java.security.util.PRNG;
import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.util.logging.Logger;

public class PKCS1_V1_5
extends BasePad {
    private static final Logger log = null;
    private EME_PKCS1_V1_5 codec;

    PKCS1_V1_5() {
        super("eme-pkcs1-v1.5");
    }

    public void setup() {
        this.codec = EME_PKCS1_V1_5.getInstance(this.blockSize);
    }

    public byte[] pad(byte[] in, int offset, int length) {
        byte[] M = new byte[length];
        System.arraycopy(in, offset, M, 0, length);
        byte[] EM = this.codec.encode(M);
        byte[] result = new byte[this.blockSize - length];
        System.arraycopy(EM, 0, result, 0, result.length);
        return result;
    }

    public int unpad(byte[] in, int offset, int length) throws WrongPaddingException {
        byte[] EM = new byte[length];
        System.arraycopy(in, offset, EM, 0, length);
        int result = length - this.codec.decode(EM).length;
        return result;
    }

    public boolean selfTest() {
        int[] mLen = new int[]{16, 20, 32, 48, 64};
        byte[] M = new byte[mLen[mLen.length - 1]];
        PRNG.getInstance().nextBytes(M);
        byte[] EM = new byte[1024];
        int bs = 256;
        while (bs < 1025) {
            this.init(bs);
            int i = 0;
            while (i < mLen.length) {
                int j = mLen[i];
                byte[] p = this.pad(M, 0, j);
                if (j + p.length != this.blockSize) {
                    return false;
                }
                System.arraycopy(p, 0, EM, 0, p.length);
                System.arraycopy(M, 0, EM, p.length, j);
                try {
                    if (p.length != this.unpad(EM, 0, this.blockSize)) {
                        return false;
                    }
                }
                catch (WrongPaddingException wrongPaddingException) {
                    return false;
                }
                ++i;
            }
            this.reset();
            bs += 256;
        }
        return true;
    }
}

