/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.java.security.util.Sequence;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.BaseMode;
import java.util.Arrays;
import java.util.Iterator;

public class CTR
extends BaseMode
implements Cloneable {
    private int off;
    private byte[] counter;
    private byte[] enc;

    CTR(IBlockCipher underlyingCipher, int cipherBlockSize) {
        super("ctr", underlyingCipher, cipherBlockSize);
    }

    private CTR(CTR that) {
        this((IBlockCipher)that.cipher.clone(), that.cipherBlockSize);
    }

    public Object clone() {
        return new CTR(this);
    }

    public void setup() {
        if (this.modeBlockSize > this.cipherBlockSize) {
            throw new IllegalArgumentException("mode size exceeds cipher block size");
        }
        this.off = 0;
        this.counter = new byte[this.cipherBlockSize];
        int i = this.cipherBlockSize - 1;
        int j = this.iv.length - 1;
        while (i >= 0 && j >= 0) {
            this.counter[i--] = this.iv[j--];
        }
        this.enc = new byte[this.cipherBlockSize];
        this.cipher.encryptBlock(this.counter, 0, this.enc, 0);
    }

    public void teardown() {
        if (this.counter != null) {
            Arrays.fill(this.counter, (byte)0);
        }
        if (this.enc != null) {
            Arrays.fill(this.enc, (byte)0);
        }
    }

    public void encryptBlock(byte[] in, int i, byte[] out, int o) {
        this.ctr(in, i, out, o);
    }

    public void decryptBlock(byte[] in, int i, byte[] out, int o) {
        this.ctr(in, i, out, o);
    }

    public Iterator blockSizes() {
        return new Sequence(1, this.cipherBlockSize).iterator();
    }

    private void ctr(byte[] in, int inOffset, byte[] out, int outOffset) {
        int i = 0;
        while (i < this.modeBlockSize) {
            out[outOffset++] = (byte)(in[inOffset++] ^ this.enc[this.off++]);
            if (this.off == this.cipherBlockSize) {
                int j = this.cipherBlockSize - 1;
                while (j >= 0) {
                    int n = j;
                    this.counter[n] = (byte)(this.counter[n] + 1);
                    if ((this.counter[j] & 0xFF) != 0) break;
                    --j;
                }
                if (j == 0) {
                    int n = this.cipherBlockSize - 1;
                    this.counter[n] = (byte)(this.counter[n] + 1);
                }
                this.off = 0;
                this.cipher.encryptBlock(this.counter, 0, this.enc, 0);
            }
            ++i;
        }
    }
}

