/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.Util;
import java.io.IOException;
import java.util.Arrays;

public class GeneralName {
    private final Kind kind;
    private final byte[] name;
    private final byte[] encoded;

    public GeneralName(byte[] encoded) throws IOException {
        DERReader reader = new DERReader(encoded);
        DERValue value = reader.read();
        if (value.getTagClass() != 128) {
            throw new IOException("malformed GeneralName");
        }
        this.encoded = value.getEncoded();
        this.kind = Kind.forTag(value.getTag());
        switch (this.kind) {
            case otherName: {
                this.name = value.getEncoded();
                this.name[0] = 48;
                reader.read();
                reader.read();
                break;
            }
            case rfc822Name: {
                this.name = (byte[])value.getValue();
                break;
            }
            case dNSName: {
                this.name = (byte[])value.getValue();
                break;
            }
            case x400Address: {
                this.name = (byte[])value.getValue();
                break;
            }
            case directoryName: {
                this.name = value.getEncoded();
                this.name[0] = 48;
                break;
            }
            case ediPartyName: {
                this.name = value.getEncoded();
                this.name[0] = 48;
                break;
            }
            case uniformResourceIdentifier: {
                this.name = (byte[])value.getValue();
                break;
            }
            case iPAddress: {
                this.name = (byte[])value.getValue();
                break;
            }
            case registeredId: {
                this.name = value.getEncoded();
                this.name[0] = 6;
                break;
            }
            default: {
                this.name = null;
            }
        }
    }

    public GeneralName(Kind kind, byte[] name) {
        this.kind = kind;
        this.name = (byte[])name.clone();
        this.encoded = null;
    }

    public Kind kind() {
        return this.kind;
    }

    public byte[] name() {
        return (byte[])this.name.clone();
    }

    public byte[] encoded() {
        try {
            return (byte[])this.encoded.clone();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean equals(Object o) {
        try {
            GeneralName that = (GeneralName)o;
            return that.kind() == this.kind() && Arrays.equals(this.name, that.name);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [ kind=" + (Object)((Object)this.kind) + "; name=" + Util.hexDump(this.name, "") + " ]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        otherName(0),
        rfc822Name(1),
        dNSName(2),
        x400Address(3),
        directoryName(4),
        ediPartyName(5),
        uniformResourceIdentifier(6),
        iPAddress(7),
        registeredId(8);

        private int tag;

        private Kind(int tag) {
            this.tag = tag;
        }

        public static Kind forTag(int tag) {
            switch (tag) {
                case 0: {
                    return otherName;
                }
                case 1: {
                    return rfc822Name;
                }
                case 2: {
                    return dNSName;
                }
                case 3: {
                    return x400Address;
                }
                case 4: {
                    return directoryName;
                }
                case 5: {
                    return ediPartyName;
                }
                case 6: {
                    return uniformResourceIdentifier;
                }
                case 7: {
                    return iPAddress;
                }
                case 8: {
                    return registeredId;
                }
            }
            throw new IllegalArgumentException("invalid tag: " + tag);
        }

        public int tag() {
            return this.tag;
        }
    }
}

