/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.loader;

import gnu.java.net.loader.FileResource;
import gnu.java.net.loader.Resource;
import gnu.java.net.loader.URLLoader;
import gnu.java.net.loader.URLStreamHandlerCache;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.StringTokenizer;

public final class FileURLLoader
extends URLLoader {
    File dir;

    public FileURLLoader(URLClassLoader classloader, URLStreamHandlerCache cache, URLStreamHandlerFactory factory, URL url, URL absoluteUrl) {
        super(classloader, cache, factory, url, absoluteUrl);
        this.dir = new File(absoluteUrl.getFile());
    }

    public Resource getResource(String name) {
        File file;
        block3: {
            try {
                file = this.walkPathComponents(name);
                if (file != null) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return new FileResource(this, file);
    }

    private File walkPathComponents(String resourceFileName) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(resourceFileName, File.separator);
        File currentFile = this.dir;
        int tokenCount = stringTokenizer.countTokens();
        int i = 0;
        while (i < tokenCount - 1) {
            String currentToken = stringTokenizer.nextToken();
            if ("..".equals(currentToken) && currentFile.equals(this.dir)) {
                return null;
            }
            if (!(currentFile = new File(currentFile, currentToken)).exists() || !currentFile.isDirectory()) {
                return null;
            }
            ++i;
        }
        if (tokenCount > 0) {
            String currentToken = stringTokenizer.nextToken();
            if ("..".equals(currentToken) && currentFile.equals(this.dir)) {
                return null;
            }
            if (!(currentFile = new File(currentFile, currentToken)).exists()) {
                return null;
            }
        }
        return currentFile.getCanonicalFile();
    }
}

