/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.management;

import gnu.classpath.SystemProperties;
import gnu.java.lang.management.BeanImpl;
import gnu.java.lang.management.VMThreadMXBeanImpl;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.NotCompliantMBeanException;

public final class ThreadMXBeanImpl
extends BeanImpl
implements ThreadMXBean {
    private static final String CURRENT_THREAD_TIME_SUPPORT = "gnu.java.lang.management.CurrentThreadTimeSupport";
    private static final String THREAD_TIME_SUPPORT = "gnu.java.lang.management.ThreadTimeSupport";
    private static final String CONTENTION_SUPPORT = "gnu.java.lang.management.ThreadContentionSupport";
    private static final String TIME_ENABLED = "gnu.java.lang.management.ThreadTimeInitallyEnabled";
    private static final String MONITOR_SUPPORT = "gnu.java.lang.management.MonitorUsageMonitoringSupport";
    private static final String SYNCHRONIZER_SUPPORT = "gnu.java.lang.management.OwnableSynchronizerUsageMonitoringSupport";
    private boolean timeEnabled = Boolean.parseBoolean(SystemProperties.getProperty("gnu.java.lang.management.ThreadTimeInitallyEnabled"));
    private boolean contentionEnabled = false;

    public ThreadMXBeanImpl() throws NotCompliantMBeanException {
        super((Class)ThreadMXBean.class);
    }

    public ThreadInfo[] dumpAllThreads(boolean lockedMonitors, boolean lockedSynchronizers) {
        return this.getThreadInfo(this.getAllThreadIds(), lockedMonitors, lockedSynchronizers);
    }

    public long[] findDeadlockedThreads() {
        this.checkMonitorPermissions();
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Ownable synchronizer usage monitoring is not provided by this VM.");
        }
        return VMThreadMXBeanImpl.findDeadlockedThreads();
    }

    public long[] findMonitorDeadlockedThreads() {
        this.checkMonitorPermissions();
        return VMThreadMXBeanImpl.findMonitorDeadlockedThreads();
    }

    public long[] getAllThreadIds() {
        this.checkMonitorPermissions();
        return VMThreadMXBeanImpl.getAllThreadIds();
    }

    public long getCurrentThreadCpuTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time not supported.");
        }
        if (!this.timeEnabled) {
            return -1L;
        }
        return VMThreadMXBeanImpl.getCurrentThreadCpuTime();
    }

    public long getCurrentThreadUserTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread user time not supported.");
        }
        if (!this.timeEnabled) {
            return -1L;
        }
        return VMThreadMXBeanImpl.getCurrentThreadUserTime();
    }

    public int getDaemonThreadCount() {
        return VMThreadMXBeanImpl.getDaemonThreadCount();
    }

    public int getPeakThreadCount() {
        return VMThreadMXBeanImpl.getPeakThreadCount();
    }

    public int getThreadCount() {
        return VMThreadMXBeanImpl.getThreadCount();
    }

    public long getThreadCpuTime(long id) {
        if (!this.isThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time not supported.");
        }
        if (id <= 0L) {
            throw new IllegalArgumentException("Invalid thread id: " + id);
        }
        if (!this.timeEnabled) {
            return -1L;
        }
        return VMThreadMXBeanImpl.getThreadCpuTime(id);
    }

    public ThreadInfo getThreadInfo(long id) {
        return this.getThreadInfo(id, 0);
    }

    public ThreadInfo[] getThreadInfo(long[] ids) {
        return this.getThreadInfo(ids, 0);
    }

    public ThreadInfo getThreadInfo(long id, int maxDepth) {
        this.checkMonitorPermissions();
        if (id <= 0L) {
            throw new IllegalArgumentException("Invalid thread id: " + id);
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException("Invalid depth: " + maxDepth);
        }
        return VMThreadMXBeanImpl.getThreadInfoForId(id, maxDepth);
    }

    public ThreadInfo[] getThreadInfo(long[] ids, int maxDepth) {
        this.checkMonitorPermissions();
        if (maxDepth < 0) {
            throw new IllegalArgumentException("Invalid depth: " + maxDepth);
        }
        ThreadInfo[] infos = new ThreadInfo[ids.length];
        int a = 0;
        while (a < ids.length) {
            if (ids[a] <= 0L) {
                throw new IllegalArgumentException("Invalid thread id " + a + ": " + ids[a]);
            }
            infos[a] = VMThreadMXBeanImpl.getThreadInfoForId(ids[a], maxDepth);
            ++a;
        }
        return infos;
    }

    public ThreadInfo[] getThreadInfo(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers) {
        ThreadInfo info;
        int n;
        int n2;
        ThreadInfo[] threadInfoArray;
        this.checkMonitorPermissions();
        if (lockedMonitors && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitor usage monitoring is not provided by this VM.");
        }
        if (lockedSynchronizers && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Ownable synchronizer usage monitoring is not provided by this VM.");
        }
        ThreadInfo[] infos = this.getThreadInfo(ids, Integer.MAX_VALUE);
        if (lockedMonitors) {
            threadInfoArray = infos;
            n2 = infos.length;
            n = 0;
            while (n < n2) {
                info = threadInfoArray[n];
                VMThreadMXBeanImpl.getMonitorInfo(info);
                ++n;
            }
        }
        if (lockedSynchronizers) {
            threadInfoArray = infos;
            n2 = infos.length;
            n = 0;
            while (n < n2) {
                info = threadInfoArray[n];
                VMThreadMXBeanImpl.getLockInfo(info);
                ++n;
            }
        }
        return infos;
    }

    public long getThreadUserTime(long id) {
        if (!this.isThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread user time not supported.");
        }
        if (id <= 0L) {
            throw new IllegalArgumentException("Invalid thread id: " + id);
        }
        if (!this.timeEnabled) {
            return -1L;
        }
        return VMThreadMXBeanImpl.getThreadUserTime(id);
    }

    public long getTotalStartedThreadCount() {
        return VMThreadMXBeanImpl.getTotalStartedThreadCount();
    }

    public boolean isCurrentThreadCpuTimeSupported() {
        if (this.isThreadCpuTimeSupported()) {
            return true;
        }
        return SystemProperties.getProperty(CURRENT_THREAD_TIME_SUPPORT) != null;
    }

    public boolean isObjectMonitorUsageSupported() {
        return SystemProperties.getProperty(MONITOR_SUPPORT) != null;
    }

    public boolean isSynchronizerUsageSupported() {
        return SystemProperties.getProperty(SYNCHRONIZER_SUPPORT) != null;
    }

    public boolean isThreadContentionMonitoringEnabled() {
        if (this.isThreadContentionMonitoringSupported()) {
            return this.contentionEnabled;
        }
        throw new UnsupportedOperationException("Contention monitoring not supported.");
    }

    public boolean isThreadContentionMonitoringSupported() {
        return SystemProperties.getProperty(CONTENTION_SUPPORT) != null;
    }

    public boolean isThreadCpuTimeEnabled() {
        if (this.isThreadCpuTimeSupported() || this.isCurrentThreadCpuTimeSupported()) {
            return this.timeEnabled;
        }
        throw new UnsupportedOperationException("Thread time not supported.");
    }

    public boolean isThreadCpuTimeSupported() {
        return SystemProperties.getProperty(THREAD_TIME_SUPPORT) != null;
    }

    public void resetPeakThreadCount() {
        this.checkControlPermissions();
        VMThreadMXBeanImpl.resetPeakThreadCount();
    }

    public void setThreadContentionMonitoringEnabled(boolean enable) {
        this.checkControlPermissions();
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Contention monitoring not supported.");
        }
        this.contentionEnabled = enable;
    }

    public void setThreadCpuTimeEnabled(boolean enable) {
        this.checkControlPermissions();
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread time not supported.");
        }
        this.timeEnabled = enable;
    }
}

