/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;

public class AsyncImage
extends Image {
    Image realImage;
    HashSet<ImageObserver> observers = new HashSet();

    AsyncImage(URL url) {
        Loader l = new Loader(url);
        Thread t = new Thread(l);
        t.start();
    }

    public void flush() {
    }

    public Graphics getGraphics() {
        Image r = this.realImage;
        Graphics g = null;
        if (r != null) {
            g = r.getGraphics();
        }
        return g;
    }

    public int getHeight(ImageObserver observer) {
        this.addObserver(observer);
        int height = 0;
        Image r = this.realImage;
        if (r != null) {
            height = r.getHeight(observer);
        }
        return height;
    }

    public Object getProperty(String name, ImageObserver observer) {
        this.addObserver(observer);
        Image r = this.realImage;
        Object prop = null;
        if (r != null) {
            prop = r.getProperty(name, observer);
        }
        return prop;
    }

    public ImageProducer getSource() {
        Image r = this.realImage;
        ImageProducer source = r == null ? new NullImageSource() : r.getSource();
        return source;
    }

    public int getWidth(ImageObserver observer) {
        this.addObserver(observer);
        int width = 0;
        Image r = this.realImage;
        if (r != null) {
            width = r.getWidth(observer);
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addObserver(ImageObserver obs) {
        if (obs != null) {
            AsyncImage asyncImage = this;
            synchronized (asyncImage) {
                HashSet<ImageObserver> observs = this.observers;
                if (observs != null) {
                    observs.add(obs);
                } else {
                    obs.imageUpdate(this, 39, 0, 0, this.realImage.getWidth(null), this.realImage.getHeight(null));
                }
            }
        }
    }

    static Image realImage(Image img, ImageObserver obs) {
        if (img instanceof AsyncImage) {
            ((AsyncImage)img).addObserver(obs);
            Image r = ((AsyncImage)img).realImage;
            if (r != null) {
                img = r;
            }
        }
        return img;
    }

    void notifyObservers(int status) {
        assert (Thread.holdsLock(this));
        HashSet<ImageObserver> observs = this.observers;
        if (observs != null) {
            Image r = this.realImage;
            for (ImageObserver obs : observs) {
                obs.imageUpdate(this, status, 0, 0, r.getWidth(null), r.getHeight(null));
            }
        }
    }

    int checkImage(ImageObserver obs) {
        this.addObserver(obs);
        int flags = 0;
        if (this.realImage != null) {
            flags = 39;
        }
        return flags;
    }

    private class Loader
    implements Runnable {
        private URL url;

        Loader(URL u) {
            this.url = u;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedImage image;
            try {
                GtkImage gtkImage = new GtkImage(this.url);
                image = CairoSurface.getBufferedImage(gtkImage);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                image = null;
            }
            AsyncImage.this.realImage = GtkToolkit.imageOrError(image);
            AsyncImage asyncImage = AsyncImage.this;
            synchronized (asyncImage) {
                AsyncImage.this.notifyObservers(39);
                AsyncImage.this.observers = null;
            }
        }
    }

    private class NullImageSource
    implements ImageProducer {
        private ArrayList<ImageConsumer> consumers = new ArrayList();

        NullImageSource() {
        }

        public void addConsumer(ImageConsumer ic) {
            this.consumers.add(ic);
        }

        public boolean isConsumer(ImageConsumer ic) {
            return this.consumers.contains(ic);
        }

        public void removeConsumer(ImageConsumer ic) {
            this.consumers.remove(ic);
        }

        public void requestTopDownLeftRightResend(ImageConsumer ic) {
            this.startProduction(ic);
        }

        public void startProduction(ImageConsumer ic) {
            this.consumers.add(ic);
            int i = this.consumers.size() - 1;
            while (i >= 0) {
                ImageConsumer c = this.consumers.get(i);
                c.setDimensions(1, 1);
                ic.imageComplete(2);
                --i;
            }
        }
    }
}

