/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import gnu.java.awt.color.ColorLookUpTable;
import gnu.java.awt.color.ColorSpaceConverter;
import gnu.java.awt.color.SrgbConverter;
import java.awt.color.ICC_Profile;

public class ClutProfileConverter
implements ColorSpaceConverter {
    private ColorLookUpTable toPCS;
    private ColorLookUpTable fromPCS;
    private int nChannels;

    public ClutProfileConverter(ICC_Profile profile) {
        this.nChannels = profile.getNumComponents();
        try {
            this.toPCS = new ColorLookUpTable(profile, 1093812784);
        }
        catch (Exception exception) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = new ColorLookUpTable(profile, 1110589744);
        }
        catch (Exception exception) {
            this.fromPCS = null;
        }
        if (this.toPCS != null || this.fromPCS != null) {
            return;
        }
        try {
            this.toPCS = new ColorLookUpTable(profile, 1093812785);
        }
        catch (Exception exception) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = new ColorLookUpTable(profile, 1110589745);
        }
        catch (Exception exception) {
            this.fromPCS = null;
        }
        if (this.toPCS != null || this.fromPCS != null) {
            return;
        }
        try {
            this.toPCS = new ColorLookUpTable(profile, 1093812786);
        }
        catch (Exception exception) {
            this.toPCS = null;
        }
        try {
            this.fromPCS = new ColorLookUpTable(profile, 1110589746);
        }
        catch (Exception exception) {
            this.fromPCS = null;
        }
        if (this.toPCS == null && this.fromPCS == null) {
            throw new IllegalArgumentException("No CLUTs in profile!");
        }
    }

    public float[] toCIEXYZ(float[] in) {
        if (this.toPCS != null) {
            return this.toPCS.lookup(in);
        }
        return new float[3];
    }

    public float[] toRGB(float[] in) {
        return SrgbConverter.XYZtoRGB(this.toCIEXYZ(in));
    }

    public float[] fromCIEXYZ(float[] in) {
        if (this.fromPCS != null) {
            return this.fromPCS.lookup(in);
        }
        return new float[this.nChannels];
    }

    public float[] fromRGB(float[] in) {
        return this.fromCIEXYZ(SrgbConverter.RGBtoXYZ(in));
    }
}

