/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.value;

import gnu.classpath.jdwp.exception.InvalidClassException;
import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.exception.InvalidTagException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.value.ValueFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class Value {
    private byte _tag;

    protected Value(byte tag) {
        this._tag = tag;
    }

    public byte getTag() {
        return this._tag;
    }

    public void writeUntagged(DataOutputStream os) throws IOException {
        this.write(os);
    }

    public void writeTagged(DataOutputStream os) throws IOException {
        os.write(this._tag);
        this.write(os);
    }

    protected abstract void write(DataOutputStream var1) throws IOException;

    protected abstract Object getObject();

    public static Object getUntaggedObject(ByteBuffer bb, Class type) throws JdwpInternalErrorException, InvalidObjectException, InvalidClassException {
        Value val = ValueFactory.createFromUntagged(bb, type);
        return val.getObject();
    }

    public static Object getTaggedObject(ByteBuffer bb) throws JdwpInternalErrorException, InvalidObjectException, InvalidTagException {
        Value val = ValueFactory.createFromTagged(bb);
        return val.getObject();
    }
}

