/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.InvalidFieldException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.MethodResult;
import gnu.classpath.jdwp.value.ObjectValue;
import gnu.classpath.jdwp.value.Value;
import gnu.classpath.jdwp.value.ValueFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class ClassTypeCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeSuperclass(bb, os);
                    break;
                }
                case 2: {
                    this.executeSetValues(bb, os);
                    break;
                }
                case 3: {
                    this.executeInvokeMethod(bb, os);
                    break;
                }
                case 4: {
                    this.executeNewInstance(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in ClassType Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private void executeSuperclass(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        Class superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            os.writeLong(0L);
        } else {
            ReferenceTypeId clazzId = this.idMan.getReferenceTypeId(superClazz);
            clazzId.write(os);
        }
    }

    private void executeSetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        refId.getType();
        int numValues = bb.getInt();
        int i = 0;
        while (i < numValues) {
            ObjectId fieldId = this.idMan.readObjectId(bb);
            Field field = (Field)fieldId.getObject();
            Object value = Value.getUntaggedObject(bb, field.getType());
            try {
                field.setAccessible(true);
                field.set(null, value);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidFieldException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new JdwpInternalErrorException(ex);
            }
            ++i;
        }
    }

    private void executeInvokeMethod(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        MethodResult mr = this.invokeMethod(bb);
        Throwable exception = mr.getThrownException();
        ObjectId eId = this.idMan.getObjectId(exception);
        mr.getReturnedValue().writeTagged(os);
        eId.writeTagged(os);
    }

    private void executeNewInstance(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        MethodResult mr = this.invokeMethod(bb);
        Throwable exception = mr.getThrownException();
        if (exception == null && !(mr.getReturnedValue() instanceof ObjectValue)) {
            throw new JdwpInternalErrorException("new instance returned non-object");
        }
        ObjectValue ov = (ObjectValue)mr.getReturnedValue();
        ObjectId oId = this.idMan.getObjectId(ov.getValue());
        ObjectId eId = this.idMan.getObjectId(exception);
        oId.writeTagged(os);
        eId.writeTagged(os);
    }

    private MethodResult invokeMethod(ByteBuffer bb) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        ObjectId tId = this.idMan.readObjectId(bb);
        Thread thread = (Thread)tId.getObject();
        VMMethod method = VMMethod.readId(clazz, bb);
        int args = bb.getInt();
        Value[] values = new Value[args];
        int i = 0;
        while (i < args) {
            values[i] = ValueFactory.createFromTagged(bb);
            ++i;
        }
        int invokeOpts = bb.getInt();
        MethodResult mr = VMVirtualMachine.executeMethod(null, thread, clazz, method, values, invokeOpts);
        return mr;
    }
}

