/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Test;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public final class NodeTypeTest
extends Test {
    final short type;
    final String data;

    public NodeTypeTest(short type) {
        this(type, null);
    }

    public NodeTypeTest(short type, String data) {
        this.type = type;
        this.data = data;
    }

    public short getNodeType() {
        return this.type;
    }

    public String getData() {
        return this.data;
    }

    public boolean matches(Node node2, int pos, int len) {
        short nodeType = node2.getNodeType();
        switch (nodeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                return this.type <= 0 || nodeType == this.type;
            }
            case 7: {
                if (this.type > 0) {
                    if (nodeType != this.type) {
                        return false;
                    }
                    if (this.data != null && !this.data.equals(((ProcessingInstruction)node2).getTarget())) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public Test clone(Object context) {
        return new NodeTypeTest(this.type, this.data);
    }

    public boolean references(QName var) {
        return false;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "node()";
            }
            case 3: {
                return "text()";
            }
            case 8: {
                return "comment()";
            }
            case 7: {
                if (this.data != null) {
                    return "processing-instruction('" + this.data + "')";
                }
                return "processing-instruction()";
            }
        }
        throw new IllegalStateException();
    }
}

