/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.Registry;
import gnu.java.security.sig.ISignatureCodec;
import java.io.ByteArrayOutputStream;

public class RSAPKCS1V1_5SignatureRawCodec
implements ISignatureCodec {
    public int getFormatID() {
        return 1;
    }

    public byte[] encodeSignature(Object signature) {
        byte[] buffer;
        try {
            buffer = (byte[])signature;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Signature/codec mismatch");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(Registry.MAGIC_RAW_RSA_PKCS1V1_5_SIGNATURE[0]);
        baos.write(Registry.MAGIC_RAW_RSA_PKCS1V1_5_SIGNATURE[1]);
        baos.write(Registry.MAGIC_RAW_RSA_PKCS1V1_5_SIGNATURE[2]);
        baos.write(Registry.MAGIC_RAW_RSA_PKCS1V1_5_SIGNATURE[3]);
        baos.write(1);
        int length = buffer.length;
        baos.write(length >>> 24);
        baos.write(length >>> 16 & 0xFF);
        baos.write(length >>> 8 & 0xFF);
        baos.write(length & 0xFF);
        baos.write(buffer, 0, length);
        return baos.toByteArray();
    }

    public Object decodeSignature(byte[] input) {
        if (input[0] != Registry.MAGIC_RAW_RSA_PKCS1V1_5_SIGNATURE[0] || input[1] != Registry.MAGIC_RAW_RSA_PKCS1V1_5_SIGNATURE[1] || input[2] != Registry.MAGIC_RAW_RSA_PKCS1V1_5_SIGNATURE[2] || input[3] != Registry.MAGIC_RAW_RSA_PKCS1V1_5_SIGNATURE[3]) {
            throw new IllegalArgumentException("Signature/codec mismatch");
        }
        if (input[4] != 1) {
            throw new IllegalArgumentException("Wrong or unsupported format version");
        }
        int i = 5;
        int l = input[i++] << 24 | (input[i++] & 0xFF) << 16 | (input[i++] & 0xFF) << 8 | input[i++] & 0xFF;
        byte[] result = new byte[l];
        System.arraycopy(input, i, result, 0, l);
        return result;
    }
}

