/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Log;
import org.eclipse.core.internal.indexing.Page;
import org.eclipse.core.internal.indexing.PageStore;
import org.eclipse.core.internal.indexing.PageStoreException;

class LogWriter {
    protected FileOutputStream out;
    protected PageStore pageStore;

    LogWriter() {
    }

    public static void putModifiedPages(PageStore pageStore, Map modifiedPages) throws PageStoreException {
        LogWriter writer = new LogWriter();
        try {
            writer.open(pageStore);
            writer.putModifiedPages(modifiedPages);
        }
        finally {
            writer.close();
        }
    }

    protected void open(PageStore store) throws PageStoreException {
        this.pageStore = store;
        try {
            this.out = new FileOutputStream(Log.name(store.getName()));
        }
        catch (IOException e) {
            throw new PageStoreException(21, (Throwable)e);
        }
    }

    protected void close() {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {}
        this.out = null;
    }

    protected void putModifiedPages(Map modifiedPages) throws PageStoreException {
        Buffer b4 = new Buffer(4);
        byte[] pageBuffer = new byte[8192];
        int numberOfPages = modifiedPages.size();
        b4.put(0, 4, numberOfPages);
        try {
            this.write(b4.getByteArray());
            for (Page page : modifiedPages.values()) {
                int pageNumber = page.getPageNumber();
                b4.put(0, 4, pageNumber);
                this.write(b4.getByteArray());
                page.toBuffer(pageBuffer);
                this.write(pageBuffer);
            }
        }
        catch (IOException e) {
            throw new PageStoreException(24, (Throwable)e);
        }
    }

    public void write(byte[] buffer) throws IOException {
        this.out.write(buffer);
    }
}

