/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import org.eclipse.jface.internal.databinding.internal.beans.JavaBeanObservableList;
import org.eclipse.jface.internal.databinding.internal.beans.JavaBeanObservableMultiMapping;
import org.eclipse.jface.internal.databinding.internal.beans.JavaBeanObservableValue;
import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.description.Property;
import org.eclipse.jface.internal.databinding.provisional.description.TableModelDescription;
import org.eclipse.jface.internal.databinding.provisional.factories.IObservableFactory;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservableCollection;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;

public final class BeanObservableFactory
implements IObservableFactory {
    private final DataBindingContext dataBindingContext;
    private final Class[] includedTypes;
    private final Class[] excludedTypes;

    public BeanObservableFactory(DataBindingContext dataBindingContext, Class[] includedTypes, Class[] excludedTypes) {
        this.dataBindingContext = dataBindingContext;
        this.includedTypes = includedTypes;
        this.excludedTypes = excludedTypes;
    }

    public IObservable createObservable(Object description) {
        if (description instanceof Property) {
            Property property = (Property)description;
            if (property.getObject() != null) {
                BeanInfo beanInfo;
                Object object = property.getObject();
                Class<?> objectClass = object.getClass();
                if (this.includedTypes != null) {
                    boolean included = false;
                    int i = 0;
                    while (i < this.includedTypes.length) {
                        if (this.includedTypes[i].isAssignableFrom(objectClass)) {
                            included = true;
                            break;
                        }
                        ++i;
                    }
                    if (!included) {
                        return null;
                    }
                }
                if (this.excludedTypes != null) {
                    int i = 0;
                    while (i < this.excludedTypes.length) {
                        if (this.excludedTypes[i].isAssignableFrom(objectClass)) {
                            return null;
                        }
                        ++i;
                    }
                }
                try {
                    beanInfo = Introspector.getBeanInfo(objectClass);
                }
                catch (IntrospectionException introspectionException) {
                    return null;
                }
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                int i = 0;
                while (i < propertyDescriptors.length) {
                    PropertyDescriptor descriptor = propertyDescriptors[i];
                    if (descriptor.getName().equals(property.getPropertyID())) {
                        if (descriptor.getPropertyType().isArray() || Collection.class.isAssignableFrom(descriptor.getPropertyType())) {
                            Class<Object> elementType;
                            Class<?> clazz = elementType = descriptor.getPropertyType().isArray() ? descriptor.getPropertyType().getComponentType() : property.getPropertyType();
                            if (elementType == null) {
                                elementType = Object.class;
                            }
                            return new JavaBeanObservableList(object, descriptor, elementType);
                        }
                        return new JavaBeanObservableValue(object, descriptor);
                    }
                    ++i;
                }
            }
        } else if (description instanceof TableModelDescription) {
            TableModelDescription tableModelDescription = (TableModelDescription)description;
            IObservable collectionObservable = tableModelDescription.getObservableList();
            if (collectionObservable == null) {
                collectionObservable = this.dataBindingContext.createObservable(tableModelDescription.getCollectionProperty());
            }
            if (collectionObservable == null) {
                return null;
            }
            if (!(collectionObservable instanceof IObservableList)) {
                throw new BindingException("collection inside a TableModelDescription needs to be IObservableList");
            }
            IObservable readableList = collectionObservable;
            Object[] columnIDs = tableModelDescription.getColumnIDs();
            PropertyDescriptor[] propertyDescriptors = new PropertyDescriptor[columnIDs.length];
            Class elementType = (Class)readableList.getElementType();
            int i = 0;
            while (i < columnIDs.length) {
                propertyDescriptors[i] = this.getPropertyDescriptor(elementType, (String)columnIDs[i]);
                ++i;
            }
            return new JavaBeanObservableMultiMapping((IObservableCollection)readableList, propertyDescriptors);
        }
        return null;
    }

    private PropertyDescriptor getPropertyDescriptor(Class elementType, String propertyName) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(elementType);
        }
        catch (IntrospectionException ex) {
            throw new BindingException("Cannot introspect " + elementType, ex);
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < propertyDescriptors.length) {
            if (propertyDescriptors[i].getName().equals(propertyName)) {
                return propertyDescriptors[i];
            }
            ++i;
        }
        return null;
    }
}

