/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ModelCompareEditorInput;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenInCompareAction
extends Action {
    private ISynchronizePageSite site;
    private final ISynchronizeParticipant participant;

    public OpenInCompareAction(ISynchronizePageSite site, ISynchronizeParticipant participant) {
        this.participant = participant;
        this.site = site;
        Utils.initAction((IAction)this, "action.openInCompareEditor.");
    }

    public void run() {
        ISelection selection = this.site.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof SyncInfoModelElement) {
                SyncInfo info = ((SyncInfoModelElement)obj).getSyncInfo();
                if (info != null) {
                    OpenInCompareAction.openCompareEditor(this.participant, info, !OpenStrategy.activateOnOpen(), this.site);
                }
            } else if (obj != null) {
                OpenInCompareAction.openCompareEditor(this.participant, obj, !OpenStrategy.activateOnOpen(), this.site);
            }
        }
    }

    public static IEditorInput openCompareEditor(ISynchronizeParticipant participant, Object object, boolean keepFocus, ISynchronizePageSite site) {
        ModelSynchronizeParticipant msp;
        ICompareInput input;
        SyncInfo info;
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)participant);
        if (object instanceof SyncInfoModelElement && (info = ((SyncInfoModelElement)object).getSyncInfo()) != null) {
            return OpenInCompareAction.openCompareEditor(participant, info, keepFocus, site);
        }
        if (participant instanceof ModelSynchronizeParticipant && (input = (msp = (ModelSynchronizeParticipant)participant).asCompareInput(object)) != null && OpenInCompareAction.isOkToOpen(site, participant, input)) {
            return OpenInCompareAction.openCompareEditor(new ModelCompareEditorInput(msp, input), keepFocus, site);
        }
        return null;
    }

    private static boolean isOkToOpen(final ISynchronizePageSite site, ISynchronizeParticipant participant, final ICompareInput input) {
        if (participant instanceof ModelSynchronizeParticipant && input instanceof ISynchronizationCompareInput) {
            final ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)participant;
            final boolean[] result = new boolean[1];
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            result[0] = msp.checkForBufferChange(site.getShell(), (ISynchronizationCompareInput)input, true, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                Utils.handleError(site.getShell(), e, null, null);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            return result[0];
        }
        return true;
    }

    public static CompareEditorInput openCompareEditor(ISynchronizeParticipant participant, SyncInfo info, boolean keepFocus, ISynchronizePageSite site) {
        Assert.isNotNull((Object)info);
        Assert.isNotNull((Object)participant);
        if (info.getLocal().getType() != 1) {
            return null;
        }
        SyncInfoCompareInput input = new SyncInfoCompareInput(participant, info);
        return OpenInCompareAction.openCompareEditor(input, keepFocus, site);
    }

    private static CompareEditorInput openCompareEditor(CompareEditorInput input, boolean keepFocus, ISynchronizePageSite site) {
        IWorkbenchPage page = null;
        if (site == null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        } else {
            page = site.getWorkbenchSite().getPage();
        }
        if (page != null) {
            OpenInCompareAction.openCompareEditor(input, page);
            if (site != null && keepFocus) {
                site.setFocus();
            }
            return input;
        }
        return null;
    }

    public static void openCompareEditor(CompareEditorInput input, IWorkbenchPage page) {
        if (page == null || input == null) {
            return;
        }
        IEditorPart editor = OpenInCompareAction.findReusableCompareEditor(page);
        if (editor != null) {
            IEditorInput otherInput = editor.getEditorInput();
            if (otherInput.equals(input)) {
                page.activate((IWorkbenchPart)editor);
            } else {
                CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                page.activate((IWorkbenchPart)editor);
            }
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)input);
        }
    }

    public static IEditorPart findReusableCompareEditor(IWorkbenchPage page) {
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && (part.getEditorInput() instanceof SyncInfoCompareInput || part.getEditorInput() instanceof ModelCompareEditorInput) && part instanceof IReusableEditor && !part.isDirty()) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public static IEditorPart findOpenCompareEditor(IWorkbenchPartSite site, IResource resource) {
        IWorkbenchPage page = site.getPage();
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null) {
                SyncInfo inputInfo;
                IEditorInput input = part.getEditorInput();
                if (part != null && input instanceof SyncInfoCompareInput && (inputInfo = ((SyncInfoCompareInput)input).getSyncInfo()).getLocal().equals((Object)resource)) {
                    return part;
                }
            }
            ++i;
        }
        return null;
    }

    public static IEditorPart findOpenCompareEditor(IWorkbenchPartSite site, Object object, ISynchronizeParticipant participant) {
        if (object instanceof SyncInfoModelElement) {
            SyncInfoModelElement element = (SyncInfoModelElement)object;
            SyncInfo info = element.getSyncInfo();
            return OpenInCompareAction.findOpenCompareEditor(site, info.getLocal());
        }
        IWorkbenchPage page = site.getPage();
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorInput input;
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && (input = part.getEditorInput()) instanceof ModelCompareEditorInput && ((ModelCompareEditorInput)input).matches(object, participant)) {
                return part;
            }
            ++i;
        }
        return null;
    }
}

