/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.history.IRefactoringDescriptorDeleteQuery;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.history.EditRefactoringDetailsDialog;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringPropertyPage;
import org.eclipse.ltk.ui.refactoring.history.IRefactoringHistoryControl;
import org.eclipse.swt.widgets.Shell;

public final class RefactoringHistoryEditHelper {
    public static void promptRefactoringDelete(final Shell shell, IRunnableContext context, final IRefactoringHistoryControl control, final IRefactoringDescriptorDeleteQuery query, final IRefactoringHistoryProvider provider, final RefactoringDescriptorProxy[] descriptors) {
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)control);
        Assert.isNotNull((Object)query);
        Assert.isNotNull((Object)provider);
        Assert.isNotNull((Object)descriptors);
        final RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        try {
            service.connect();
            try {
                context.run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, 300);
                            try {
                                service.deleteRefactoringDescriptors(descriptors, query, (IProgressMonitor)new SubProgressMonitor(monitor, 280, 2));
                            }
                            catch (CoreException exception) {
                                final Throwable throwable = exception.getStatus().getException();
                                if (throwable instanceof IOException) {
                                    shell.getDisplay().syncExec(new Runnable(){

                                        public void run() {
                                            MessageDialog.openError((Shell)shell, (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)throwable.getLocalizedMessage());
                                        }
                                    });
                                }
                                throw new InvocationTargetException(exception);
                            }
                            if (query.hasDeletions()) {
                                final RefactoringHistory history = provider.getRefactoringHistory((IProgressMonitor)new SubProgressMonitor(monitor, 20, 2));
                                shell.getDisplay().syncExec(new Runnable(){

                                    public void run() {
                                        control.setInput(history);
                                        control.setCheckedDescriptors(RefactoringPropertyPage.EMPTY_DESCRIPTORS);
                                    }
                                });
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
            }
            catch (InterruptedException interruptedException) {}
        }
        finally {
            service.disconnect();
        }
    }

    public static void promptRefactoringDetails(IRunnableContext context, final IRefactoringHistoryControl control, final RefactoringDescriptorProxy descriptor) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)descriptor);
        final RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        try {
            service.connect();
            final String[] details = new String[]{""};
            try {
                context.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String current;
                        RefactoringDescriptor resolved = descriptor.requestDescriptor(monitor);
                        if (resolved != null && (current = resolved.getComment()) != null) {
                            details[0] = current;
                        }
                    }
                });
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
            }
            catch (InterruptedException interruptedException) {}
            final EditRefactoringDetailsDialog dialog = new EditRefactoringDetailsDialog(control.getControl().getShell(), RefactoringUIMessages.RefactoringPropertyPage_edit_caption, Messages.format(RefactoringUIMessages.RefactoringPropertyPage_edit_message, descriptor.getDescription()), details[0]);
            if (dialog.open() == 0) {
                try {
                    context.run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                service.setRefactoringComment(descriptor, dialog.getDetails(), monitor);
                                control.setSelectedDescriptors(new RefactoringDescriptorProxy[]{descriptor});
                            }
                            catch (CoreException exception) {
                                throw new InvocationTargetException(exception);
                            }
                        }
                    });
                }
                catch (InvocationTargetException exception) {
                    RefactoringUIPlugin.log(exception);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            service.disconnect();
        }
    }

    private RefactoringHistoryEditHelper() {
    }

    public static interface IRefactoringHistoryProvider {
        public RefactoringHistory getRefactoringHistory(IProgressMonitor var1);
    }
}

