/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RefactoringWizardDialog
extends WizardDialog {
    private static final String DIALOG_SETTINGS = "RefactoringWizard";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private IDialogSettings fSettings;
    private boolean fMakeNextButtonDefault;

    public RefactoringWizardDialog(Shell parent, RefactoringWizard wizard) {
        super(parent, (IWizard)wizard);
        this.setShellStyle(this.getShellStyle() | 0x10);
        IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
        wizard.setDialogSettings(settings);
        String settingsSectionId = "RefactoringWizard." + wizard.getRefactoring().getName();
        this.fSettings = settings.getSection(settingsSectionId);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(settingsSectionId);
            settings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 100);
            this.fSettings.put(HEIGHT, 100);
            this.setMinimumPageSize(100, 100);
        } else {
            try {
                int width = this.fSettings.getInt(WIDTH);
                int height = this.fSettings.getInt(HEIGHT);
                this.setPageSize(width, height);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.getRefactoringWizard().getRefactoring().setValidationContext((Object)newShell);
    }

    protected void cancelPressed() {
        this.storeCurrentSize();
        super.cancelPressed();
    }

    protected void finishPressed() {
        this.storeCurrentSize();
        super.finishPressed();
    }

    private void storeCurrentSize() {
        IWizardPage page = this.getCurrentPage();
        Composite control = page.getControl().getParent();
        Point size = control.getSize();
        this.fSettings.put(WIDTH, size.x);
        this.fSettings.put(HEIGHT, size.y);
    }

    public void updateButtons() {
        super.updateButtons();
        if (!this.fMakeNextButtonDefault) {
            return;
        }
        if (this.getShell() == null) {
            return;
        }
        Button next = this.getButton(15);
        if (next.isEnabled()) {
            this.getShell().setDefaultButton(next);
        }
    }

    public void makeNextButtonDefault() {
        this.fMakeNextButtonDefault = true;
    }

    public Button getCancelButton() {
        return this.getButton(1);
    }

    private RefactoringWizard getRefactoringWizard() {
        return (RefactoringWizard)this.getWizard();
    }
}

