/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class LinksData
extends RequestData {
    private String topicHref;
    private String selectedTopicId = "";
    private IHelpResource[] links;

    public LinksData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.topicHref = request.getParameter("topic");
        if (this.topicHref != null && this.topicHref.length() == 0) {
            this.topicHref = null;
        }
        if (this.isLinksRequest()) {
            this.loadLinks();
        }
    }

    public boolean isLinksRequest() {
        return this.request.getParameter("contextId") != null;
    }

    public int getLinksCount() {
        return this.links.length;
    }

    public String getSelectedTopicId() {
        return this.selectedTopicId;
    }

    public String getTopicHref(int i) {
        return UrlUtil.getHelpURL(this.links[i].getHref());
    }

    public String getTopicLabel(int i) {
        return UrlUtil.htmlEncode(this.links[i].getLabel());
    }

    public String getTopicTocLabel(int i) {
        IToc toc = this.findTocForTopic(this.links[i].getHref());
        if (toc != null) {
            return UrlUtil.htmlEncode(toc.getLabel());
        }
        return "";
    }

    private IToc findTocForTopic(String href) {
        ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
        int i = 0;
        while (i < tocs.length) {
            ITopic topic = tocs[i].getTopic(href);
            if (topic != null) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    private void loadLinks() {
        String contextId = this.request.getParameter("contextId");
        IContext context = HelpSystem.getContext((String)contextId);
        if (context == null) {
            this.links = new IHelpResource[0];
            return;
        }
        this.links = context.getRelatedTopics();
        if (this.links == null) {
            this.links = new IHelpResource[0];
            return;
        }
        int i = 0;
        while (i < this.links.length) {
            if (this.links[i].getHref().equals(this.topicHref)) {
                this.selectedTopicId = "a" + i;
                break;
            }
            ++i;
        }
    }
}

