/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPVariableElement;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CPVariableElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private Image fJARImage;
    private Image fFolderImage;
    private boolean fShowResolvedVariables;
    private Color fResolvedBackground;

    public CPVariableElementLabelProvider(boolean showResolvedVariables) {
        ImageRegistry reg = JavaPlugin.getDefault().getImageRegistry();
        this.fJARImage = reg.get("org.eclipse.jdt.ui.jar_l_obj.gif");
        this.fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        this.fShowResolvedVariables = showResolvedVariables;
        this.fResolvedBackground = null;
    }

    public Image getImage(Object element) {
        if (element instanceof CPVariableElement) {
            CPVariableElement curr = (CPVariableElement)element;
            IPath path = curr.getPath();
            if (path.toFile().isFile()) {
                return this.fJARImage;
            }
            return this.fFolderImage;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof CPVariableElement) {
            CPVariableElement curr = (CPVariableElement)element;
            String name = curr.getName();
            IPath path = curr.getPath();
            StringBuffer buf = new StringBuffer(name);
            if (curr.isReserved()) {
                buf.append(' ');
                buf.append(NewWizardMessages.CPVariableElementLabelProvider_reserved);
            }
            if (path != null) {
                buf.append(" - ");
                if (!path.isEmpty()) {
                    buf.append(path.toOSString());
                } else {
                    buf.append(NewWizardMessages.CPVariableElementLabelProvider_empty);
                }
            }
            return buf.toString();
        }
        return super.getText(element);
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof CPVariableElement) {
            CPVariableElement curr = (CPVariableElement)element;
            if (!this.fShowResolvedVariables && curr.isReserved()) {
                if (this.fResolvedBackground == null) {
                    Display display = Display.getCurrent();
                    this.fResolvedBackground = display.getSystemColor(29);
                }
                return this.fResolvedBackground;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
    }
}

