/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.ui.viewsupport.SourcePositionSorter;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public abstract class AbstractHierarchyViewerSorter
extends ViewerSorter {
    private static final int OTHER = 1;
    private static final int CLASS = 2;
    private static final int INTERFACE = 3;
    private static final int ANONYM = 4;
    private JavaElementSorter fNormalSorter = new JavaElementSorter();
    private SourcePositionSorter fSourcePositonSorter = new SourcePositionSorter();

    protected abstract ITypeHierarchy getHierarchy(IType var1);

    public abstract boolean isSortByDefiningType();

    public abstract boolean isSortAlphabetically();

    protected int getTypeFlags(IType type) throws JavaModelException {
        return type.getFlags();
    }

    public int category(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            if (type.getElementName().length() == 0) {
                return 4;
            }
            try {
                int flags = this.getTypeFlags(type);
                if (Flags.isInterface((int)flags)) {
                    return 3;
                }
                return 2;
            }
            catch (JavaModelException javaModelException) {}
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        if (!this.isSortAlphabetically() && !this.isSortByDefiningType()) {
            return this.fSourcePositonSorter.compare(viewer, e1, e2);
        }
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (cat1 == 1) {
            if (this.isSortByDefiningType()) {
                try {
                    IType def2;
                    IType def1 = e1 instanceof IMethod ? this.getDefiningType((IMethod)e1) : null;
                    IType iType = def2 = e2 instanceof IMethod ? this.getDefiningType((IMethod)e2) : null;
                    if (def1 != null) {
                        if (def2 == null) {
                            return -1;
                        }
                        if (!def2.equals(def1)) {
                            return this.compareInHierarchy(def1, def2);
                        }
                    } else if (def2 != null) {
                        return 1;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            if (this.isSortAlphabetically()) {
                return this.fNormalSorter.compare(viewer, e1, e2);
            }
            return 0;
        }
        if (cat1 == 4) {
            return 0;
        }
        if (this.isSortAlphabetically()) {
            String name1 = ((IType)e1).getElementName();
            String name2 = ((IType)e2).getElementName();
            return this.getCollator().compare(name1, name2);
        }
        return 0;
    }

    private IType getDefiningType(IMethod method) throws JavaModelException {
        int flags = method.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || method.isConstructor()) {
            return null;
        }
        IType declaringType = method.getDeclaringType();
        MethodOverrideTester tester = new MethodOverrideTester(declaringType, this.getHierarchy(declaringType));
        IMethod res = tester.findDeclaringMethod(method, true);
        if (res == null) {
            return null;
        }
        return res.getDeclaringType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int compareInHierarchy(IType def1, IType def2) {
        if (JavaModelUtil.isSuperType(this.getHierarchy(def1), def2, def1)) {
            return 1;
        }
        if (JavaModelUtil.isSuperType(this.getHierarchy(def2), def1, def2)) {
            return -1;
        }
        try {
            int flags1 = this.getTypeFlags(def1);
            int flags2 = this.getTypeFlags(def2);
            if (Flags.isInterface((int)flags1)) {
                if (!Flags.isInterface((int)flags2)) {
                    return 1;
                }
            } else if (Flags.isInterface((int)flags2)) {
                return -1;
            }
        }
        catch (JavaModelException javaModelException) {}
        String name1 = def1.getElementName();
        String name2 = def2.getElementName();
        return this.getCollator().compare(name1, name2);
    }
}

