/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.swt.graphics.Image;

public class NewVariableCompletionProposal
extends LinkedCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    public static final int PARAM = 3;
    public static final int CONST_FIELD = 4;
    public static final int ENUM_CONST = 5;
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private static final String KEY_INITIALIZER = "initializer";
    private final int fVariableKind;
    private final SimpleName fOriginalNode;
    private final ITypeBinding fSenderBinding;

    public NewVariableCompletionProposal(String label, ICompilationUnit cu, int variableKind, SimpleName node, ITypeBinding senderBinding, int relevance, Image image) {
        super(label, cu, (ASTRewrite)null, relevance, image);
        if (senderBinding == null) {
            Assert.isTrue((variableKind == 3 || variableKind == 1 ? 1 : 0) != 0);
        } else {
            Assert.isTrue((boolean)Bindings.isDeclarationBinding((IBinding)senderBinding));
        }
        this.fVariableKind = variableKind;
        this.fOriginalNode = node;
        this.fSenderBinding = senderBinding;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit cu = ASTResolving.findParentCompilationUnit((ASTNode)this.fOriginalNode);
        switch (this.fVariableKind) {
            case 3: {
                return this.doAddParam(cu);
            }
            case 2: 
            case 4: {
                return this.doAddField(cu);
            }
            case 1: {
                return this.doAddLocal(cu);
            }
            case 5: {
                return this.doAddEnumConst(cu);
            }
        }
        throw new IllegalArgumentException("Unsupported variable kind: " + this.fVariableKind);
    }

    private ASTRewrite doAddParam(CompilationUnit cu) throws CoreException {
        AST ast = cu.getAST();
        SimpleName node = this.fOriginalNode;
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)node);
        if (decl instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ImportRewrite imports = this.createImportRewrite((CompilationUnit)decl.getRoot());
            SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
            newDecl.setType(this.evaluateVariableType(ast, imports, (IBinding)methodDeclaration.resolveBinding()));
            newDecl.setName(ast.newSimpleName(node.getIdentifier()));
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.PARAMETERS_PROPERTY);
            listRewriter.insertLast((ASTNode)newDecl, null);
            this.addLinkedPosition(rewrite.track((ASTNode)newDecl.getType()), false, KEY_TYPE);
            this.addLinkedPosition(rewrite.track((ASTNode)node), true, KEY_NAME);
            this.addLinkedPosition(rewrite.track((ASTNode)newDecl.getName()), false, KEY_NAME);
            Javadoc javadoc = methodDeclaration.getJavadoc();
            if (javadoc != null) {
                HashSet<String> leadingNames = new HashSet<String>();
                for (SingleVariableDeclaration curr : methodDeclaration.parameters()) {
                    leadingNames.add(curr.getName().getIdentifier());
                }
                SimpleName newTagRef = ast.newSimpleName(node.getIdentifier());
                TagElement newTagElement = ast.newTagElement();
                newTagElement.setTagName("@param");
                newTagElement.fragments().add(newTagRef);
                TextElement commentStart = ast.newTextElement();
                newTagElement.fragments().add(commentStart);
                this.addLinkedPosition(rewrite.track((ASTNode)newTagRef), true, KEY_NAME);
                this.addLinkedPosition(rewrite.track((ASTNode)commentStart), false, "comment_start");
                ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTagElement, leadingNames);
            }
            return rewrite;
        }
        return null;
    }

    private boolean isAssigned(Statement statement, SimpleName name) {
        ExpressionStatement exstat;
        if (statement instanceof ExpressionStatement && (exstat = (ExpressionStatement)statement).getExpression() instanceof Assignment) {
            Assignment assignment = (Assignment)exstat.getExpression();
            return assignment.getLeftHandSide() == name;
        }
        return false;
    }

    private boolean isForStatementInit(Statement statement, SimpleName name) {
        ForStatement forStatement;
        List list;
        if (statement instanceof ForStatement && (list = (forStatement = (ForStatement)statement).initializers()).size() == 1 && list.get(0) instanceof Assignment) {
            Assignment assignment = (Assignment)list.get(0);
            return assignment.getLeftHandSide() == name;
        }
        return false;
    }

    private ASTRewrite doAddLocal(CompilationUnit cu) throws CoreException {
        SimpleName node;
        Block body;
        AST ast = cu.getAST();
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration((ASTNode)this.fOriginalNode);
        IMethodBinding targetContext = null;
        if (decl instanceof MethodDeclaration) {
            body = ((MethodDeclaration)decl).getBody();
            targetContext = ((MethodDeclaration)decl).resolveBinding();
        } else if (decl instanceof Initializer) {
            body = ((Initializer)decl).getBody();
            targetContext = Bindings.getBindingOfParentType((ASTNode)decl);
        } else {
            return null;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite imports = this.createImportRewrite((CompilationUnit)decl.getRoot());
        SimpleName[] names = this.getAllReferences(body);
        ASTNode dominant = this.getDominantNode(names);
        Statement dominantStatement = ASTResolving.findParentStatement(dominant);
        if (ASTNodes.isControlStatementBody(dominantStatement.getLocationInParent())) {
            dominantStatement = (Statement)dominantStatement.getParent();
        }
        if (this.isAssigned(dominantStatement, node = names[0])) {
            Assignment assignment = (Assignment)node.getParent();
            VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
            VariableDeclarationExpression newDecl = ast.newVariableDeclarationExpression(newDeclFrag);
            newDecl.setType(this.evaluateVariableType(ast, imports, (IBinding)targetContext));
            Expression placeholder = (Expression)rewrite.createCopyTarget((ASTNode)assignment.getRightHandSide());
            newDeclFrag.setInitializer(placeholder);
            newDeclFrag.setName(ast.newSimpleName(node.getIdentifier()));
            rewrite.replace((ASTNode)assignment, (ASTNode)newDecl, null);
            this.addLinkedPosition(rewrite.track((ASTNode)newDecl.getType()), false, KEY_TYPE);
            this.addLinkedPosition(rewrite.track((ASTNode)newDeclFrag.getName()), true, KEY_NAME);
            this.setEndPosition(rewrite.track(assignment.getParent()));
            return rewrite;
        }
        if (dominant != dominantStatement && this.isForStatementInit(dominantStatement, node)) {
            Assignment assignment = (Assignment)node.getParent();
            VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
            VariableDeclarationExpression expression = ast.newVariableDeclarationExpression(frag);
            frag.setName(ast.newSimpleName(node.getIdentifier()));
            Expression placeholder = (Expression)rewrite.createCopyTarget((ASTNode)assignment.getRightHandSide());
            frag.setInitializer(placeholder);
            expression.setType(this.evaluateVariableType(ast, imports, (IBinding)targetContext));
            rewrite.replace((ASTNode)assignment, (ASTNode)expression, null);
            this.addLinkedPosition(rewrite.track((ASTNode)expression.getType()), false, KEY_TYPE);
            this.addLinkedPosition(rewrite.track((ASTNode)frag.getName()), true, KEY_NAME);
            this.setEndPosition(rewrite.track((ASTNode)expression));
            return rewrite;
        }
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        VariableDeclarationStatement newDecl = ast.newVariableDeclarationStatement(newDeclFrag);
        newDeclFrag.setName(ast.newSimpleName(node.getIdentifier()));
        newDecl.setType(this.evaluateVariableType(ast, imports, (IBinding)targetContext));
        this.addLinkedPosition(rewrite.track((ASTNode)newDecl.getType()), false, KEY_TYPE);
        this.addLinkedPosition(rewrite.track((ASTNode)node), true, KEY_NAME);
        this.addLinkedPosition(rewrite.track((ASTNode)newDeclFrag.getName()), false, KEY_NAME);
        Statement statement = dominantStatement;
        List list = ASTNodes.getContainingList((ASTNode)statement);
        while (list == null && statement.getParent() instanceof Statement) {
            statement = (Statement)statement.getParent();
            list = ASTNodes.getContainingList((ASTNode)statement);
        }
        if (list != null) {
            ASTNode parent = statement.getParent();
            StructuralPropertyDescriptor childProperty = statement.getLocationInParent();
            if (childProperty.isChildListProperty()) {
                rewrite.getListRewrite(parent, (ChildListPropertyDescriptor)childProperty).insertBefore((ASTNode)newDecl, (ASTNode)statement, null);
                return rewrite;
            }
            return null;
        }
        return rewrite;
    }

    private SimpleName[] getAllReferences(Block body) {
        SimpleName[] names = LinkedNodeFinder.findByProblems((ASTNode)body, this.fOriginalNode);
        if (names == null) {
            return new SimpleName[]{this.fOriginalNode};
        }
        if (names.length > 1) {
            Arrays.sort(names, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((SimpleName)o1).getStartPosition() - ((SimpleName)o2).getStartPosition();
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
        }
        return names;
    }

    private ASTNode getDominantNode(SimpleName[] names) {
        SimpleName dominator = names[0];
        int i = 1;
        while (i < names.length) {
            SimpleName curr = names[i];
            if (curr != dominator) {
                ASTNode parent = this.getCommonParent((ASTNode)curr, (ASTNode)dominator);
                if (curr.getStartPosition() < dominator.getStartPosition()) {
                    dominator = curr;
                }
                while (dominator.getParent() != parent) {
                    dominator = dominator.getParent();
                }
            }
            ++i;
        }
        int parentKind = dominator.getParent().getNodeType();
        if (parentKind != 8 && parentKind != 24) {
            return dominator.getParent();
        }
        return dominator;
    }

    private ASTNode getCommonParent(ASTNode node1, ASTNode node2) {
        ASTNode parent = node1.getParent();
        while (parent != null && !ASTNodes.isParent(node2, parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private ASTRewrite doAddField(CompilationUnit astRoot) throws CoreException {
        SimpleName node = this.fOriginalNode;
        boolean isInDifferentCU = false;
        ASTNode newTypeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        if (newTypeDecl == null) {
            astRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
            isInDifferentCU = true;
        }
        ImportRewrite imports = this.createImportRewrite(astRoot);
        if (newTypeDecl != null) {
            AST ast = newTypeDecl.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
            fragment.setName(ast.newSimpleName(node.getIdentifier()));
            Type type = this.evaluateVariableType(ast, imports, (IBinding)this.fSenderBinding);
            FieldDeclaration newDecl = ast.newFieldDeclaration(fragment);
            newDecl.setType(type);
            newDecl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.evaluateFieldModifiers(newTypeDecl)));
            if (this.fSenderBinding.isInterface() || this.fVariableKind == 4) {
                fragment.setInitializer(ASTNodeFactory.newDefaultExpression(ast, type, 0));
            }
            ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty(newTypeDecl);
            List decls = (List)newTypeDecl.getStructuralProperty((StructuralPropertyDescriptor)property);
            int maxOffset = isInDifferentCU ? -1 : node.getStartPosition();
            int insertIndex = this.findFieldInsertIndex(decls, newDecl, maxOffset);
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, property);
            listRewriter.insertAt((ASTNode)newDecl, insertIndex, null);
            ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this, rewrite, newDecl.modifiers(), this.fSenderBinding.isInterface());
            this.addLinkedPosition(rewrite.track((ASTNode)newDecl.getType()), false, KEY_TYPE);
            if (!isInDifferentCU) {
                this.addLinkedPosition(rewrite.track((ASTNode)node), true, KEY_NAME);
            }
            this.addLinkedPosition(rewrite.track((ASTNode)fragment.getName()), false, KEY_NAME);
            if (fragment.getInitializer() != null) {
                this.addLinkedPosition(rewrite.track((ASTNode)fragment.getInitializer()), false, KEY_INITIALIZER);
            }
            return rewrite;
        }
        return null;
    }

    private int findFieldInsertIndex(List decls, FieldDeclaration newDecl, int maxOffset) {
        if (maxOffset != -1) {
            int i = decls.size() - 1;
            while (i >= 0) {
                ASTNode curr = (ASTNode)decls.get(i);
                if (maxOffset > curr.getStartPosition() + curr.getLength()) {
                    return ASTNodes.getInsertionIndex((BodyDeclaration)newDecl, decls.subList(0, i + 1));
                }
                --i;
            }
            return 0;
        }
        return ASTNodes.getInsertionIndex((BodyDeclaration)newDecl, decls);
    }

    private Type evaluateVariableType(AST ast, ImportRewrite imports, IBinding targetContext) throws CoreException {
        ITypeBinding[] bindings;
        MethodInvocation parent;
        if (this.fOriginalNode.getParent() instanceof MethodInvocation && (parent = (MethodInvocation)this.fOriginalNode.getParent()).getExpression() == this.fOriginalNode && (bindings = ASTResolving.getQualifierGuess(this.fOriginalNode.getRoot(), parent.getName().getIdentifier(), parent.arguments(), targetContext)).length > 0) {
            int i = 0;
            while (i < bindings.length) {
                this.addLinkedPositionProposal(KEY_TYPE, bindings[i]);
                ++i;
            }
            return imports.addImport(bindings[0], ast);
        }
        ITypeBinding binding = ASTResolving.guessBindingForReference((ASTNode)this.fOriginalNode);
        if (binding != null) {
            if (binding.isWildcardType() && (binding = ASTResolving.normalizeWildcardType(binding, this.isVariableAssigned(), ast)) == null) {
                binding = ast.resolveWellKnownType("java.lang.Object");
            }
            if (this.isVariableAssigned()) {
                ITypeBinding[] typeProposals = ASTResolving.getRelaxingTypes(ast, binding);
                int i = 0;
                while (i < typeProposals.length) {
                    this.addLinkedPositionProposal(KEY_TYPE, typeProposals[i]);
                    ++i;
                }
            }
            return imports.addImport(binding, ast);
        }
        Type type = ASTResolving.guessTypeForReference(ast, (ASTNode)this.fOriginalNode);
        if (type != null) {
            return type;
        }
        if (this.fVariableKind == 4) {
            return ast.newSimpleType((Name)ast.newSimpleName("String"));
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    private boolean isVariableAssigned() {
        ASTNode parent = this.fOriginalNode.getParent();
        return parent instanceof Assignment && this.fOriginalNode == ((Assignment)parent).getLeftHandSide();
    }

    private int evaluateFieldModifiers(ASTNode newTypeDecl) {
        if (this.fSenderBinding.isAnnotation()) {
            return 0;
        }
        if (this.fSenderBinding.isInterface()) {
            FieldDeclaration[] fieldDecls = ((TypeDeclaration)newTypeDecl).getFields();
            if (fieldDecls.length > 0) {
                return fieldDecls[0].getModifiers();
            }
            return 0;
        }
        int modifiers = 0;
        if (this.fVariableKind == 4) {
            modifiers |= 0x18;
        } else {
            ASTNode parent = this.fOriginalNode.getParent();
            if (parent instanceof QualifiedName) {
                IBinding qualifierBinding = ((QualifiedName)parent).getQualifier().resolveBinding();
                if (qualifierBinding instanceof ITypeBinding) {
                    modifiers |= 8;
                }
            } else if (ASTResolving.isInStaticContext((ASTNode)this.fOriginalNode)) {
                modifiers |= 8;
            }
        }
        ASTNode node = ASTResolving.findParentType((ASTNode)this.fOriginalNode, true);
        modifiers = newTypeDecl.equals((Object)node) ? (modifiers |= 2) : (node instanceof AnonymousClassDeclaration ? (modifiers |= 4) : (modifiers |= 1));
        return modifiers;
    }

    private ASTRewrite doAddEnumConst(CompilationUnit astRoot) throws CoreException {
        SimpleName node = this.fOriginalNode;
        ASTNode newTypeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        if (newTypeDecl == null) {
            astRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        if (newTypeDecl != null) {
            AST ast = newTypeDecl.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            EnumConstantDeclaration constDecl = ast.newEnumConstantDeclaration();
            constDecl.setName(ast.newSimpleName(node.getIdentifier()));
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
            listRewriter.insertLast((ASTNode)constDecl, null);
            this.addLinkedPosition(rewrite.track((ASTNode)constDecl.getName()), false, KEY_NAME);
            return rewrite;
        }
        return null;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

