/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class CompilationUnitRewrite {
    private ICompilationUnit fCu;
    private List fTextEditGroups = new ArrayList();
    private CompilationUnit fRoot;
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;
    private ImportRemover fImportRemover;
    private boolean fResolveBindings = true;
    private boolean fStatementsRecovery = false;
    private final WorkingCopyOwner fOwner;
    private IDocument fRememberContent = null;

    public CompilationUnitRewrite(ICompilationUnit cu) {
        this(null, cu, null);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, ICompilationUnit cu) {
        this(owner, cu, null);
    }

    public CompilationUnitRewrite(ICompilationUnit cu, CompilationUnit root) {
        this(null, cu, root);
    }

    public CompilationUnitRewrite(WorkingCopyOwner owner, ICompilationUnit cu, CompilationUnit root) {
        this.fOwner = owner;
        this.fCu = cu;
        this.fRoot = root;
    }

    public void rememberContent() {
        this.fRememberContent = new Document();
    }

    public void setResolveBindings(boolean resolve) {
        this.fResolveBindings = resolve;
    }

    public void setStatementsRecovery(boolean statementsRecovery) {
        this.fStatementsRecovery = statementsRecovery;
    }

    public void clearASTRewrite() {
        this.fRewrite = null;
        this.fTextEditGroups = new ArrayList();
    }

    public void clearImportRewrites() {
        this.fImportRewrite = null;
    }

    public void clearASTAndImportRewrites() {
        this.clearASTRewrite();
        this.fImportRewrite = null;
    }

    public CategorizedTextEditGroup createCategorizedGroupDescription(String name, GroupCategorySet set) {
        CategorizedTextEditGroup result = new CategorizedTextEditGroup(name, set);
        this.fTextEditGroups.add(result);
        return result;
    }

    public TextEditGroup createGroupDescription(String name) {
        TextEditGroup result = new TextEditGroup(name);
        this.fTextEditGroups.add(result);
        return result;
    }

    public CompilationUnitChange createChange() throws CoreException {
        return this.createChange(true, null);
    }

    public CompilationUnitChange createChange(boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        CompilationUnitChange cuChange = new CompilationUnitChange(this.fCu.getElementName(), this.fCu);
        MultiTextEdit multiEdit = new MultiTextEdit();
        cuChange.setEdit((TextEdit)multiEdit);
        return this.attachChange(cuChange, generateGroups, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompilationUnitChange attachChange(CompilationUnitChange cuChange, boolean generateGroups, IProgressMonitor monitor) throws CoreException {
        try {
            TextEdit importsEdit;
            TextEdit rewriteEdit;
            boolean needsImportRewrite;
            boolean needsAstRewrite = this.fRewrite != null;
            boolean needsImportRemoval = this.fImportRemover != null && this.fImportRemover.hasRemovedNodes();
            boolean bl = needsImportRewrite = this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges() || needsImportRemoval;
            if (!(needsAstRewrite || needsImportRemoval || needsImportRewrite)) {
                return null;
            }
            MultiTextEdit multiEdit = (MultiTextEdit)cuChange.getEdit();
            if (multiEdit == null) {
                multiEdit = new MultiTextEdit();
                cuChange.setEdit((TextEdit)multiEdit);
            }
            if (needsAstRewrite && !CompilationUnitRewrite.isEmptyEdit(rewriteEdit = this.fRememberContent != null ? this.fRewrite.rewriteAST(this.fRememberContent, this.fCu.getJavaProject().getOptions(true)) : this.fRewrite.rewriteAST())) {
                multiEdit.addChild(rewriteEdit);
                for (TextEditGroup group : this.fTextEditGroups) {
                    if (!generateGroups) continue;
                    cuChange.addTextEditGroup(group);
                }
            }
            if (needsImportRemoval) {
                this.fImportRemover.applyRemoves(this.getImportRewrite());
            }
            if (needsImportRewrite && !CompilationUnitRewrite.isEmptyEdit(importsEdit = this.fImportRewrite.rewriteImports(monitor))) {
                multiEdit.addChild(importsEdit);
                String importUpdateName = RefactoringCoreMessages.ASTData_update_imports;
                cuChange.addTextEditGroup(new TextEditGroup(importUpdateName, importsEdit));
            }
            if (CompilationUnitRewrite.isEmptyEdit((TextEdit)multiEdit)) {
                return null;
            }
            CompilationUnitChange compilationUnitChange = cuChange;
            return compilationUnitChange;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static boolean isEmptyEdit(TextEdit edit) {
        return edit.getClass() == MultiTextEdit.class && !edit.hasChildren();
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    public CompilationUnit getRoot() {
        if (this.fRoot == null) {
            this.fRoot = new RefactoringASTParser(3).parse(this.fCu, this.fOwner, this.fResolveBindings, this.fStatementsRecovery, null);
        }
        return this.fRoot;
    }

    public AST getAST() {
        return this.getRoot().getAST();
    }

    public ASTRewrite getASTRewrite() {
        if (this.fRewrite == null) {
            this.fRewrite = ASTRewrite.create((AST)this.getRoot().getAST());
            if (this.fRememberContent != null) {
                try {
                    this.fRememberContent.set(this.fCu.getSource());
                }
                catch (JavaModelException javaModelException) {
                    this.fRememberContent = null;
                }
            }
        }
        return this.fRewrite;
    }

    public ImportRewrite getImportRewrite() {
        if (this.fImportRewrite == null) {
            try {
                this.fImportRewrite = this.fRoot == null ? StubUtility.createImportRewrite(this.fCu, true) : StubUtility.createImportRewrite(this.getRoot(), true);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        return this.fImportRewrite;
    }

    public ImportRemover getImportRemover() {
        if (this.fImportRemover == null) {
            this.fImportRemover = new ImportRemover(this.fCu.getJavaProject(), this.getRoot());
        }
        return this.fImportRemover;
    }
}

