/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;

public class PositionGroup {
    private final String fGroupId;
    private final List fPositions;
    private final List fProposals;
    private final List fDisplayStrings;
    private ITrackedNodePosition fFirstPosition;

    public ITrackedNodePosition getFirstPosition() {
        return this.fFirstPosition;
    }

    public PositionGroup(String groupID) {
        this.fGroupId = groupID;
        this.fPositions = new ArrayList();
        this.fProposals = new ArrayList();
        this.fDisplayStrings = new ArrayList();
    }

    public void addPosition(ITrackedNodePosition position) {
        this.fPositions.add(position);
    }

    public void addFirstPosition(ITrackedNodePosition position) {
        this.addPosition(position);
        this.fFirstPosition = position;
    }

    public void addProposal(String displayString, String proposal) {
        this.fProposals.add(proposal);
        this.fDisplayStrings.add(displayString);
    }

    public String getGroupId() {
        return this.fGroupId;
    }

    public ITrackedNodePosition[] getPositions() {
        return this.fPositions.toArray(new ITrackedNodePosition[this.fPositions.size()]);
    }

    public String[] getDisplayStrings() {
        return this.fDisplayStrings.toArray(new String[this.fDisplayStrings.size()]);
    }

    public String[] getProposals() {
        return this.fProposals.toArray(new String[this.fProposals.size()]);
    }
}

