/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifierOperation;
import org.eclipse.jdt.internal.corext.buildpath.IClasspathInformationProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;

public class ResetOperation
extends ClasspathModifierOperation {
    public ResetOperation(ClasspathModifier.IClasspathModifierListener listener, IClasspathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip, 9);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List selection = this.getSelectedElements();
            IJavaProject project = this.fInformationProvider.getJavaProject();
            result = this.reset(selection, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    public boolean isValid(List elements, int[] types) throws JavaModelException {
        if (elements.size() == 0) {
            return false;
        }
        IJavaProject project = this.fInformationProvider.getJavaProject();
        boolean hasResetableFragmentRoot = false;
        boolean hasOutputFolder = false;
        boolean hasResetableProject = false;
        int i = 0;
        while (i < elements.size()) {
            switch (types[i]) {
                case 1: {
                    hasResetableProject = this.isValidProject(project);
                    break;
                }
                case 2: {
                    break;
                }
                case 14: {
                    hasResetableFragmentRoot = true;
                    break;
                }
                case 12: {
                    hasOutputFolder = true;
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return hasResetableFragmentRoot || hasOutputFolder || hasResetableProject;
    }

    private boolean isValidProject(IJavaProject project) throws JavaModelException {
        IClasspathEntry entry;
        return project.isOnClasspath((IJavaElement)project) && ((entry = ClasspathModifier.getClasspathEntryFor(project.getPath(), project, 3)).getInclusionPatterns().length != 0 || entry.getExclusionPatterns().length != 0);
    }

    public String getDescription(int type) {
        if (type == 12 || type == 29) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_SetOutputToDefault;
        }
        if (type == 14 || type == 31) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_ResetFilters;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Reset;
    }
}

