/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import org.eclipse.core.internal.preferences.Activator;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.exchange.ILegacyPreferences;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class PreferencesOSGiUtils {
    private ServiceTracker logTracker = null;
    private ServiceTracker initTracker = null;
    private ServiceTracker debugTracker = null;
    private ServiceTracker bundleTracker = null;
    private ServiceTracker configurationLocationTracker = null;
    private ServiceTracker instanceLocationTracker = null;
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    private static final PreferencesOSGiUtils singleton = new PreferencesOSGiUtils();

    public static PreferencesOSGiUtils getDefault() {
        return singleton;
    }

    private PreferencesOSGiUtils() {
    }

    void openServices() {
        BundleContext context = Activator.getContext();
        if (context == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("PreferencesOSGiUtils called before plugin started");
            }
            return;
        }
        this.initTracker = new ServiceTracker(context, ILegacyPreferences.class.getName(), null);
        this.initTracker.open(true);
        this.logTracker = new ServiceTracker(context, FrameworkLog.class.getName(), null);
        this.logTracker.open();
        this.debugTracker = new ServiceTracker(context, DebugOptions.class.getName(), null);
        this.debugTracker.open();
        this.bundleTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.bundleTracker.open();
        Filter filter = null;
        try {
            filter = context.createFilter(Location.CONFIGURATION_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.configurationLocationTracker = new ServiceTracker(context, filter, null);
        this.configurationLocationTracker.open();
        try {
            filter = context.createFilter(Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.instanceLocationTracker = new ServiceTracker(context, filter, null);
        this.instanceLocationTracker.open();
    }

    void closeServices() {
        if (this.initTracker != null) {
            this.initTracker.close();
            this.initTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.configurationLocationTracker != null) {
            this.configurationLocationTracker.close();
            this.configurationLocationTracker = null;
        }
        if (this.instanceLocationTracker != null) {
            this.instanceLocationTracker.close();
            this.instanceLocationTracker = null;
        }
    }

    public ILegacyPreferences getLegacyPreferences() {
        if (this.initTracker != null) {
            return (ILegacyPreferences)this.initTracker.getService();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Legacy preference tracker is not set");
        }
        return null;
    }

    public FrameworkLog getFrameworkLog() {
        if (this.logTracker != null) {
            return (FrameworkLog)this.logTracker.getService();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Log tracker is not set");
        }
        return null;
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        if (this.debugTracker == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Debug tracker is not set");
            }
            return defaultValue;
        }
        DebugOptions options = (DebugOptions)this.debugTracker.getService();
        if (options != null && (value = options.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public Bundle getBundle(String bundleName) {
        if (this.bundleTracker == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Bundle tracker is not set");
            }
            return null;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleTracker.getService();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public Location getConfigurationLocation() {
        if (this.configurationLocationTracker != null) {
            return (Location)this.configurationLocationTracker.getService();
        }
        return null;
    }

    public Location getInstanceLocation() {
        if (this.instanceLocationTracker != null) {
            return (Location)this.instanceLocationTracker.getService();
        }
        return null;
    }
}

