/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.util.ResourceLocator;
import org.osgi.framework.Bundle;

public class PluginIndex {
    private static final String COMPLETE_FILENAME = "indexed_complete";
    private String pluginId;
    private String path;
    private SearchIndex targetIndex;
    private List indexIDs;
    private List resolvedPaths;

    public PluginIndex(String pluginId, String path, SearchIndex targetIndex) {
        this.pluginId = pluginId;
        this.path = path;
        this.targetIndex = targetIndex;
    }

    private void resolve() {
        if (this.indexIDs != null) {
            return;
        }
        this.indexIDs = new ArrayList();
        this.resolvedPaths = new ArrayList();
        Bundle bundle = Platform.getBundle((String)this.pluginId);
        if (bundle == null) {
            return;
        }
        boolean found = false;
        ArrayList availablePrefixes = ResourceLocator.getPathPrefix((String)this.targetIndex.getLocale());
        int i = 0;
        while (i < availablePrefixes.size()) {
            block15: {
                String prefix = (String)availablePrefixes.get(i);
                Path prefixedPath = new Path(String.valueOf(prefix) + this.path);
                URL url = FileLocator.find((Bundle)bundle, (IPath)prefixedPath, null);
                if (url != null) {
                    found = true;
                    if (this.isCompatible(bundle, (IPath)prefixedPath)) {
                        URL resolved;
                        try {
                            resolved = FileLocator.resolve((URL)url);
                        }
                        catch (IOException ioe) {
                            HelpBasePlugin.logError("Help index directory at " + prefixedPath + " for plugin " + bundle.getSymbolicName() + " cannot be resolved.", ioe);
                            break block15;
                        }
                        if ("file".equals(resolved.getProtocol())) {
                            this.indexIDs.add(this.getIndexId(prefix));
                            this.resolvedPaths.add(resolved.getFile());
                            if (this.isComplete(bundle, (IPath)prefixedPath)) {
                                break;
                            }
                        } else {
                            try {
                                URL localURL = FileLocator.toFileURL((URL)url);
                                if ("file".equals(localURL.getProtocol())) {
                                    this.indexIDs.add(this.getIndexId(prefix));
                                    this.resolvedPaths.add(localURL.getFile());
                                    if (this.isComplete(bundle, (IPath)prefixedPath)) {
                                        break;
                                    }
                                }
                            }
                            catch (IOException ioe) {
                                HelpBasePlugin.logError("Help index directory at " + prefixedPath + " for plugin " + bundle.getSymbolicName() + " cannot be resolved.", ioe);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (!found) {
            HelpBasePlugin.logError("Help index declared, but missing for plugin " + this.getPluginId() + ".", null);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCompatible(Bundle bundle, IPath prefixedPath) {
        block17: {
            block16: {
                url = FileLocator.find((Bundle)bundle, (IPath)prefixedPath.append("indexed_dependencies"), null);
                if (url == null) {
                    HelpBasePlugin.logError(prefixedPath.append("indexed_dependencies") + " file missing from help index \"" + this.path + "\" of plugin " + this.getPluginId(), null);
                    return false;
                }
                in = null;
                try {
                    in = url.openStream();
                    prop = new Properties();
                    prop.load(in);
                    lucene = prop.getProperty("lucene");
                    analyzer = prop.getProperty("analyzer");
                    if (this.targetIndex.isLuceneCompatible(lucene) && this.targetIndex.isAnalyzerCompatible(analyzer)) break block16;
                    if (HelpBasePlugin.DEBUG_SEARCH) {
                        System.out.println("Ignoring prebuilt help search index for plugin " + this.getPluginId() + ".  Index is not compatible with index in use.");
                    }
lbl15:
                    // 4 sources

                    while (true) {
                        if (in == null) return false;
                        break;
                    }
                }
                catch (Throwable var8_9) {
                    if (in == null) throw var8_9;
                    try {
                        in.close();
                        throw var8_9;
                    }
                    catch (IOException v1) {}
                    throw var8_9;
                }
                {
                    catch (MalformedURLException v0) {
                        ** continue;
                    }
                    catch (IOException ioe) {
                        HelpBasePlugin.logError("IOException accessing prebuilt index.", ioe);
                        break block17;
                    }
                }
                try {
                    in.close();
                    return false;
                }
                catch (IOException v2) {}
                return false;
            }
            if (in == null) return true;
            try {
                in.close();
                return true;
            }
            catch (IOException v3) {
                return true;
            }
        }
        if (in == null) return true;
        try {
            in.close();
            return true;
        }
        catch (IOException v4) {}
        return true;
    }

    private boolean isComplete(Bundle bundle, IPath prefixedPath) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)prefixedPath.append(COMPLETE_FILENAME), null);
        return url != null;
    }

    private String getIndexId(String prefix) {
        if (prefix.length() == 0) {
            return "/";
        }
        return "/" + prefix.substring(0, prefix.length() - 1);
    }

    public boolean equals(Object obj) {
        return this.pluginId.equals(obj);
    }

    public int hashCode() {
        return this.pluginId.hashCode();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(this.pluginId);
        ret.append(":");
        ret.append(this.path);
        ret.append("=");
        if (this.indexIDs == null) {
            ret.append("unresolved");
        } else {
            int i = 0;
            while (i < this.indexIDs.size()) {
                ret.append(this.indexIDs.get(i));
                ret.append("@");
                ret.append(this.resolvedPaths.get(i));
                ++i;
            }
        }
        return ret.toString();
    }

    public List getIDs() {
        this.resolve();
        return this.indexIDs;
    }

    public List getPaths() {
        this.resolve();
        return this.resolvedPaths;
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

