/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class AbstractDecoratedTextEditorPreferenceConstants {
    public static final String EDITOR_CURRENT_LINE = "currentLine";
    public static final String EDITOR_CURRENT_LINE_COLOR = "currentLineColor";
    public static final String EDITOR_TAB_WIDTH = "tabWidth";
    public static final String EDITOR_UNDO_HISTORY_SIZE = "undoHistorySize";
    public static final String EDITOR_PRINT_MARGIN = "printMargin";
    public static final String EDITOR_PRINT_MARGIN_COLOR = "printMarginColor";
    public static final String EDITOR_PRINT_MARGIN_COLUMN = "printMarginColumn";
    public static final String EDITOR_UNKNOWN_INDICATION = "othersIndication";
    public static final String EDITOR_UNKNOWN_INDICATION_COLOR = "othersIndicationColor";
    public static final String EDITOR_UNKNOWN_INDICATION_IN_OVERVIEW_RULER = "othersIndicationInOverviewRuler";
    public static final String EDITOR_OVERVIEW_RULER = "overviewRuler";
    public static final String EDITOR_LINE_NUMBER_RULER = "lineNumberRuler";
    public static final String EDITOR_LINE_NUMBER_RULER_COLOR = "lineNumberColor";
    public static final String USE_ANNOTATIONS_PREFERENCE_PAGE = "useAnnotationsPrefPage";
    public static final String USE_QUICK_DIFF_PREFERENCE_PAGE = "useQuickDiffPrefPage";
    public static final String QUICK_DIFF_ALWAYS_ON = "quickdiff.quickDiff";
    public static final String QUICK_DIFF_DEFAULT_PROVIDER = "quickdiff.defaultProvider";
    public static final String QUICK_DIFF_CHARACTER_MODE = "quickdiff.characterMode";
    public static final String EDITOR_USE_CUSTOM_CARETS = "AbstractTextEditor.Accessibility.UseCustomCarets";
    public static final String EDITOR_WIDE_CARET = "AbstractTextEditor.Accessibility.WideCaret";
    public static final String EDITOR_SELECTION_FOREGROUND_COLOR = "AbstractTextEditor.Color.SelectionForeground";
    public static final String EDITOR_SELECTION_FOREGROUND_DEFAULT_COLOR = "AbstractTextEditor.Color.SelectionForeground.SystemDefault";
    public static final String EDITOR_SELECTION_BACKGROUND_COLOR = "AbstractTextEditor.Color.SelectionBackground";
    public static final String EDITOR_SELECTION_BACKGROUND_DEFAULT_COLOR = "AbstractTextEditor.Color.SelectionBackground.SystemDefault";
    public static final String EDITOR_HYPERLINKS_ENABLED = "hyperlinksEnabled";
    public static final String EDITOR_HYPERLINK_KEY_MODIFIER = "hyperlinkKeyModifier";
    public static final String EDITOR_HYPERLINK_KEY_MODIFIER_MASK = "hyperlinkKeyModifierMask";
    public static final String EDITOR_HYPERLINK_COLOR = "hyperlinkColor";
    public static final String EDITOR_DISABLE_OVERWRITE_MODE = "disable_overwrite_mode";
    public static final String SHOW_RANGE_INDICATOR = "show_range_indicator";
    public static final String REVISION_ASK_BEFORE_QUICKDIFF_SWITCH = "quickdiff.nowarn.before.switch";

    private AbstractDecoratedTextEditorPreferenceConstants() {
    }

    public static void initializeDefaultValues(IPreferenceStore store) {
        store.setDefault(USE_ANNOTATIONS_PREFERENCE_PAGE, false);
        store.setDefault(USE_QUICK_DIFF_PREFERENCE_PAGE, false);
        store.setDefault(EDITOR_CURRENT_LINE, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_CURRENT_LINE_COLOR, (RGB)new RGB(232, 242, 254));
        store.setDefault(EDITOR_TAB_WIDTH, 4);
        store.setDefault(EDITOR_UNDO_HISTORY_SIZE, 200);
        store.setDefault(EDITOR_PRINT_MARGIN, false);
        store.setDefault(EDITOR_PRINT_MARGIN_COLUMN, 80);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_PRINT_MARGIN_COLOR, (RGB)new RGB(176, 180, 185));
        store.setDefault(EDITOR_LINE_NUMBER_RULER, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_LINE_NUMBER_RULER_COLOR, (RGB)new RGB(120, 120, 120));
        if (!store.getBoolean(USE_QUICK_DIFF_PREFERENCE_PAGE)) {
            store.setDefault(QUICK_DIFF_ALWAYS_ON, true);
            store.setDefault(QUICK_DIFF_CHARACTER_MODE, false);
            store.setDefault(QUICK_DIFF_DEFAULT_PROVIDER, "org.eclipse.ui.internal.editors.quickdiff.LastSaveReferenceProvider");
        }
        store.setDefault(EDITOR_OVERVIEW_RULER, true);
        store.setDefault(EDITOR_UNKNOWN_INDICATION, false);
        store.setDefault(EDITOR_UNKNOWN_INDICATION_IN_OVERVIEW_RULER, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_UNKNOWN_INDICATION_COLOR, (RGB)new RGB(0, 0, 0));
        store.setDefault(EDITOR_USE_CUSTOM_CARETS, false);
        store.setDefault(EDITOR_WIDE_CARET, true);
        store.setDefault(EDITOR_SELECTION_FOREGROUND_DEFAULT_COLOR, true);
        store.setDefault(EDITOR_SELECTION_BACKGROUND_DEFAULT_COLOR, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background", (RGB)new RGB(255, 255, 255));
        store.setDefault("AbstractTextEditor.Color.Background.SystemDefault", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Foreground", (RGB)new RGB(0, 0, 0));
        store.setDefault("AbstractTextEditor.Color.Foreground.SystemDefault", true);
        String mod1Name = Action.findModifierString((int)SWT.MOD1);
        store.setDefault(EDITOR_HYPERLINKS_ENABLED, true);
        store.setDefault(EDITOR_HYPERLINK_KEY_MODIFIER, mod1Name);
        store.setDefault(EDITOR_HYPERLINK_KEY_MODIFIER_MASK, SWT.MOD1);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_HYPERLINK_COLOR, (RGB)new RGB(0, 0, 255));
        store.setDefault(EDITOR_DISABLE_OVERWRITE_MODE, false);
        store.setDefault("spellingEnabled", false);
        store.setDefault("spellingEngine", "");
        store.setDefault(SHOW_RANGE_INDICATOR, true);
        store.setDefault(REVISION_ASK_BEFORE_QUICKDIFF_SWITCH, "");
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"AbstractTextEditor.Color.FindScope", (RGB)new RGB(185, 176, 180));
        MarkerAnnotationPreferences.initializeDefaultValues(store);
    }
}

