/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.build;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.util.PropertiesUtil;

public class BuildEntry
implements IBuildEntry,
IDocumentKey {
    private int fLength = -1;
    private int fOffset = -1;
    private IBuildModel fModel;
    private String fName;
    private ArrayList fTokens = new ArrayList();
    private String fLineDelimiter;

    public BuildEntry(String name, IBuildModel model) {
        this.fName = name;
        this.fModel = model;
        this.setLineDelimiter();
    }

    private void setLineDelimiter() {
        if (this.fModel instanceof IEditingModel) {
            IDocument document = ((IEditingModel)((Object)this.fModel)).getDocument();
            this.fLineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        } else {
            this.fLineDelimiter = System.getProperty("line.separator");
        }
    }

    public void addToken(String token) throws CoreException {
        if (this.fTokens.contains(token)) {
            return;
        }
        if (this.fTokens.add(token)) {
            this.getModel().fireModelObjectChanged(this, this.getName(), null, token);
        }
    }

    public String getName() {
        return this.fName;
    }

    public String[] getTokens() {
        return this.fTokens.toArray(new String[this.fTokens.size()]);
    }

    public boolean contains(String token) {
        return this.fTokens.contains(token);
    }

    public void removeToken(String token) throws CoreException {
        if (this.fTokens.remove(token)) {
            this.getModel().fireModelObjectChanged(this, this.getName(), token, null);
        }
    }

    public void renameToken(String oldToken, String newToken) throws CoreException {
        int index = this.fTokens.indexOf(oldToken);
        if (index != -1) {
            this.fTokens.set(index, newToken);
            this.getModel().fireModelObjectChanged(this, this.getName(), oldToken, newToken);
        }
    }

    public void setName(String name) {
        String oldName = this.fName;
        if (this.getModel() != null) {
            try {
                IBuild build = this.getModel().getBuild();
                build.remove(this);
                this.fName = name;
                build.add(this);
            }
            catch (CoreException e) {
                PDECore.logException(e);
            }
            this.getModel().fireModelObjectChanged(this, this.getName(), oldName, name);
        } else {
            this.fName = name;
        }
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setLength(int length) {
        this.fLength = length;
    }

    public void write(String indent, PrintWriter writer) {
    }

    public IBuildModel getModel() {
        return this.fModel;
    }

    public void processEntry(String value) {
        StringTokenizer stok = new StringTokenizer(value, ",");
        while (stok.hasMoreTokens()) {
            this.fTokens.add(stok.nextToken().trim());
        }
    }

    public String write() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PropertiesUtil.createWritableName(this.fName));
        buffer.append(" = ");
        int indentLength = this.fName.length() + 3;
        int i = 0;
        while (i < this.fTokens.size()) {
            buffer.append(PropertiesUtil.createEscapedValue(this.fTokens.get(i).toString()));
            if (i < this.fTokens.size() - 1) {
                buffer.append(",\\");
                buffer.append(this.fLineDelimiter);
                int j = 0;
                while (j < indentLength) {
                    buffer.append(" ");
                    ++j;
                }
            }
            ++i;
        }
        buffer.append(this.fLineDelimiter);
        return buffer.toString();
    }
}

