/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.ResizableDialog;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CompareDialog
extends ResizableDialog
implements IPropertyChangeListener {
    private CompareEditorInput fCompareEditorInput;
    private Button fCommitButton;

    CompareDialog(Shell shell, CompareEditorInput input) {
        super(shell, null);
        Assert.isNotNull((Object)input);
        this.fCompareEditorInput = input;
        this.fCompareEditorInput.addPropertyChangeListener(this);
        this.setHelpContextId("org.eclipse.compare.compare_dialog_context");
    }

    public boolean close() {
        if (super.close()) {
            if (this.fCompareEditorInput != null) {
                this.fCompareEditorInput.addPropertyChangeListener(this);
            }
            return true;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fCommitButton = this.createButton(parent, 0, Utilities.getString("CompareDialog.commitAction.label"), true);
        this.fCommitButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fCommitButton != null && this.fCompareEditorInput != null) {
            this.fCommitButton.setEnabled(this.fCompareEditorInput.isSaveNeeded());
        }
    }

    protected Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        Control c = this.fCompareEditorInput.createContents(parent);
        c.setLayoutData((Object)new GridData(1808));
        Shell shell = c.getShell();
        shell.setText(this.fCompareEditorInput.getTitle());
        shell.setImage(this.fCompareEditorInput.getTitleImage());
        CompareDialog.applyDialogFont((Control)parent);
        return parent;
    }

    public int open() {
        int rc = super.open();
        if (rc == 0 && this.fCompareEditorInput.isSaveNeeded()) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor pm) throws CoreException {
                    CompareDialog.this.fCompareEditorInput.saveChanges(pm);
                }
            };
            Shell shell = this.getParentShell();
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            try {
                operation.run(pmd.getProgressMonitor());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InvocationTargetException x) {
                String title = Utilities.getString("CompareDialog.saveErrorTitle");
                String msg = Utilities.getString("CompareDialog.saveErrorMessage");
                MessageDialog.openError((Shell)shell, (String)title, (String)(String.valueOf(msg) + x.getTargetException().getMessage()));
            }
        }
        return rc;
    }
}

