/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DefaultInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
DisposeListener {
    private static final int INNER_BORDER = 1;
    private PopupDialog fPopupDialog;
    private StyledText fText;
    private IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;

    public DefaultInformationControl(Shell parent, int shellStyle, int style, IInformationPresenter presenter) {
        this(parent, shellStyle, style, presenter, null);
    }

    public DefaultInformationControl(Shell parentShell, int shellStyle, final int style, IInformationPresenter presenter, String statusFieldText) {
        shellStyle = shellStyle | 0x80000 | 0x4000;
        this.fPopupDialog = new PopupDialog(parentShell, shellStyle, false, false, false, false, null, statusFieldText){

            protected Control createDialogArea(Composite parent) {
                DefaultInformationControl.this.fText = new StyledText(parent, 0xA | style);
                GridData gd = new GridData(1809);
                gd.horizontalIndent = 1;
                gd.verticalIndent = 1;
                DefaultInformationControl.this.fText.setLayoutData((Object)gd);
                DefaultInformationControl.this.fText.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\u001b') {
                            this.close();
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
                return DefaultInformationControl.this.fText;
            }
        };
        this.fPresenter = presenter;
        this.fPopupDialog.create();
    }

    public DefaultInformationControl(Shell parent, int style, IInformationPresenter presenter) {
        this(parent, 12, style, presenter);
    }

    public DefaultInformationControl(Shell parent, int style, IInformationPresenter presenter, String statusFieldText) {
        this(parent, 12, style, presenter, statusFieldText);
    }

    public DefaultInformationControl(Shell parent) {
        this(parent, 0, null);
    }

    public DefaultInformationControl(Shell parent, IInformationPresenter presenter) {
        this(parent, 0, presenter);
    }

    public void setInformation(String content) {
        if (this.fPresenter == null) {
            this.fText.setText(content);
        } else {
            this.fPresentation.clear();
            content = this.fPresenter instanceof IInformationPresenterExtension ? ((IInformationPresenterExtension)((Object)this.fPresenter)).updatePresentation((Drawable)this.fPopupDialog.getShell(), content, this.fPresentation, this.fMaxWidth, this.fMaxHeight) : this.fPresenter.updatePresentation(this.fPopupDialog.getShell().getDisplay(), content, this.fPresentation, this.fMaxWidth, this.fMaxHeight);
            if (content != null) {
                this.fText.setText(content);
                TextPresentation.applyTextPresentation(this.fPresentation, this.fText);
            } else {
                this.fText.setText("");
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fText.getWordWrap()) {
                Point currentSize = this.fPopupDialog.getShell().getSize();
                this.fPopupDialog.getShell().pack(true);
                Point newSize = this.fPopupDialog.getShell().getSize();
                if (newSize.x > currentSize.x || newSize.y > currentSize.y) {
                    this.setSize(currentSize.x, currentSize.y);
                }
            }
            this.fPopupDialog.open();
        } else {
            this.fPopupDialog.getShell().setVisible(false);
        }
    }

    public void dispose() {
        this.fPopupDialog.close();
        this.fPopupDialog = null;
    }

    public void setSize(int width, int height) {
        this.fPopupDialog.getShell().setSize(width, height);
    }

    public void setLocation(Point location) {
        this.fPopupDialog.getShell().setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        int widthHint = -1;
        if (this.fMaxWidth > -1 && this.fText.getWordWrap()) {
            widthHint = this.fMaxWidth;
        }
        return this.fPopupDialog.getShell().computeSize(widthHint, -1, true);
    }

    public Rectangle computeTrim() {
        return this.fPopupDialog.getShell().computeTrim(0, 0, 0, 0);
    }

    public Rectangle getBounds() {
        return this.fPopupDialog.getShell().getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fPopupDialog.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fPopupDialog.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        this.fPopupDialog.getShell().forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    public void widgetDisposed(DisposeEvent event) {
    }

    public static interface IInformationPresenter {
        public String updatePresentation(Display var1, String var2, TextPresentation var3, int var4, int var5);
    }

    public static interface IInformationPresenterExtension {
        public String updatePresentation(Drawable var1, String var2, TextPresentation var3, int var4, int var5);
    }
}

