/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMStandin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VMDefinitionsContainer {
    private Map fVMTypeToVMMap = new HashMap(10);
    private List fVMList;
    private List fInvalidVMList = new ArrayList(10);
    private String fDefaultVMInstallCompositeID;
    private String fDefaultVMInstallConnectorTypeID;

    public VMDefinitionsContainer() {
        this.fVMList = new ArrayList(10);
    }

    public void addVM(IVMInstall vm) {
        if (!this.fVMList.contains(vm)) {
            IVMInstallType vmInstallType = vm.getVMInstallType();
            ArrayList<IVMInstall> vmList = (ArrayList<IVMInstall>)this.fVMTypeToVMMap.get(vmInstallType);
            if (vmList == null) {
                vmList = new ArrayList<IVMInstall>(3);
                this.fVMTypeToVMMap.put(vmInstallType, vmList);
            }
            vmList.add(vm);
            File installLocation = vm.getInstallLocation();
            if (installLocation == null || !vmInstallType.validateInstallLocation(installLocation).isOK()) {
                this.fInvalidVMList.add(vm);
            }
            this.fVMList.add(vm);
        }
    }

    public void addVMList(List vmList) {
        for (IVMInstall vm : vmList) {
            this.addVM(vm);
        }
    }

    public Map getVMTypeToVMMap() {
        return this.fVMTypeToVMMap;
    }

    public List getVMList() {
        return this.fVMList;
    }

    public List getValidVMList() {
        List vms = this.getVMList();
        ArrayList resultList = new ArrayList(vms.size());
        resultList.addAll(vms);
        resultList.removeAll(this.fInvalidVMList);
        return resultList;
    }

    public String getDefaultVMInstallCompositeID() {
        return this.fDefaultVMInstallCompositeID;
    }

    public void setDefaultVMInstallCompositeID(String id) {
        this.fDefaultVMInstallCompositeID = id;
    }

    public String getDefaultVMInstallConnectorTypeID() {
        return this.fDefaultVMInstallConnectorTypeID;
    }

    public void setDefaultVMInstallConnectorTypeID(String id) {
        this.fDefaultVMInstallConnectorTypeID = id;
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = LaunchingPlugin.getDocument();
        Element config = doc.createElement("vmSettings");
        doc.appendChild(config);
        if (this.getDefaultVMInstallCompositeID() != null) {
            config.setAttribute("defaultVM", this.getDefaultVMInstallCompositeID());
        }
        if (this.getDefaultVMInstallConnectorTypeID() != null) {
            config.setAttribute("defaultVMConnector", this.getDefaultVMInstallConnectorTypeID());
        }
        Set vmInstallTypeSet = this.getVMTypeToVMMap().keySet();
        for (IVMInstallType vmInstallType : vmInstallTypeSet) {
            Element vmTypeElement = this.vmTypeAsElement(doc, vmInstallType);
            config.appendChild(vmTypeElement);
        }
        return LaunchingPlugin.serializeDocument(doc);
    }

    private Element vmTypeAsElement(Document doc, IVMInstallType vmType) {
        Element element = doc.createElement("vmType");
        element.setAttribute("id", vmType.getId());
        List vmList = (List)this.getVMTypeToVMMap().get(vmType);
        for (IVMInstall vm : vmList) {
            Element vmElement = this.vmAsElement(doc, vm);
            element.appendChild(vmElement);
        }
        return element;
    }

    private Element vmAsElement(Document doc, IVMInstall vm) {
        URL url;
        Element element = doc.createElement("vm");
        element.setAttribute("id", vm.getId());
        element.setAttribute("name", vm.getName());
        String installPath = "";
        File installLocation = vm.getInstallLocation();
        if (installLocation != null) {
            installPath = installLocation.getAbsolutePath();
        }
        element.setAttribute("path", installPath);
        LibraryLocation[] libraryLocations = vm.getLibraryLocations();
        if (libraryLocations != null) {
            Element libLocationElement = VMDefinitionsContainer.libraryLocationsAsElement(doc, libraryLocations);
            element.appendChild(libLocationElement);
        }
        if ((url = vm.getJavadocLocation()) != null) {
            element.setAttribute("javadocURL", url.toExternalForm());
        }
        if (vm instanceof IVMInstall2) {
            String vmArgs = ((IVMInstall2)((Object)vm)).getVMArgs();
            if (vmArgs != null && vmArgs.length() > 0) {
                element.setAttribute("vmargs", vmArgs);
            }
        } else {
            String[] vmArgs = vm.getVMArguments();
            if (vmArgs != null && vmArgs.length > 0) {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < vmArgs.length) {
                    buffer.append(String.valueOf(vmArgs[i]) + " ");
                    ++i;
                }
                element.setAttribute("vmargs", buffer.toString());
            }
        }
        return element;
    }

    private static Element libraryLocationsAsElement(Document doc, LibraryLocation[] locations) {
        Element root = doc.createElement("libraryLocations");
        int i = 0;
        while (i < locations.length) {
            URL url;
            Element element = doc.createElement("libraryLocation");
            element.setAttribute("jreJar", locations[i].getSystemLibraryPath().toString());
            element.setAttribute("jreSrc", locations[i].getSystemLibrarySourcePath().toString());
            IPath packageRootPath = locations[i].getPackageRootPath();
            if (packageRootPath != null) {
                element.setAttribute("pkgRoot", packageRootPath.toString());
            }
            if ((url = locations[i].getJavadocLocation()) != null) {
                element.setAttribute("jreJavadoc", url.toExternalForm());
            }
            root.appendChild(element);
            ++i;
        }
        return root;
    }

    public static VMDefinitionsContainer parseXMLIntoContainer(InputStream inputStream) throws IOException {
        VMDefinitionsContainer container = new VMDefinitionsContainer();
        VMDefinitionsContainer.parseXMLIntoContainer(inputStream, container);
        return container;
    }

    public static void parseXMLIntoContainer(InputStream inputStream, VMDefinitionsContainer container) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(inputStream);
        Element config = null;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                config = parser.parse(new InputSource(stream)).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException(LaunchingMessages.JavaRuntime_badFormat);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ((InputStream)stream).close();
                throw new IOException(LaunchingMessages.JavaRuntime_badFormat);
            }
        }
        finally {
            ((InputStream)stream).close();
        }
        if (!config.getNodeName().equalsIgnoreCase("vmSettings")) {
            throw new IOException(LaunchingMessages.JavaRuntime_badFormat);
        }
        container.setDefaultVMInstallCompositeID(config.getAttribute("defaultVM"));
        container.setDefaultVMInstallConnectorTypeID(config.getAttribute("defaultVMConnector"));
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element vmTypeElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (vmTypeElement = (Element)node).getNodeName().equalsIgnoreCase("vmType")) {
                VMDefinitionsContainer.populateVMTypes(vmTypeElement, container);
            }
            ++i;
        }
    }

    private static void populateVMTypes(Element vmTypeElement, VMDefinitionsContainer container) {
        String id = vmTypeElement.getAttribute("id");
        IVMInstallType vmType = JavaRuntime.getVMInstallType(id);
        if (vmType != null) {
            NodeList vmNodeList = vmTypeElement.getChildNodes();
            int i = 0;
            while (i < vmNodeList.getLength()) {
                Element vmElement;
                Node vmNode = vmNodeList.item(i);
                short type = vmNode.getNodeType();
                if (type == 1 && (vmElement = (Element)vmNode).getNodeName().equalsIgnoreCase("vm")) {
                    VMDefinitionsContainer.populateVMForType(vmType, vmElement, container);
                }
                ++i;
            }
        } else {
            LaunchingPlugin.log(LaunchingMessages.JavaRuntime_VM_type_element_with_unknown_id_1);
        }
    }

    private static void populateVMForType(IVMInstallType vmType, Element vmElement, VMDefinitionsContainer container) {
        String id = vmElement.getAttribute("id");
        if (id != null) {
            String vmArgs;
            String installPath = vmElement.getAttribute("path");
            if (installPath == null) {
                return;
            }
            VMStandin vmStandin = new VMStandin(vmType, id);
            vmStandin.setName(vmElement.getAttribute("name"));
            File installLocation = new File(installPath);
            vmStandin.setInstallLocation(installLocation);
            container.addVM(vmStandin);
            NodeList list = vmElement.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1) {
                    Element subElement = (Element)node;
                    String subElementName = subElement.getNodeName();
                    if (subElementName.equals("libraryLocation")) {
                        LibraryLocation loc = VMDefinitionsContainer.getLibraryLocation(subElement);
                        vmStandin.setLibraryLocations(new LibraryLocation[]{loc});
                        break;
                    }
                    if (subElementName.equals("libraryLocations")) {
                        VMDefinitionsContainer.setLibraryLocations(vmStandin, subElement);
                        break;
                    }
                }
                ++i;
            }
            String externalForm = vmElement.getAttribute("javadocURL");
            if (externalForm != null && externalForm.length() > 0) {
                try {
                    vmStandin.setJavadocLocation(new URL(externalForm));
                }
                catch (MalformedURLException e) {
                    LaunchingPlugin.log(e);
                }
            }
            if ((vmArgs = vmElement.getAttribute("vmargs")) != null && vmArgs.length() > 0) {
                vmStandin.setVMArgs(vmArgs);
            }
        } else {
            LaunchingPlugin.log(LaunchingMessages.JavaRuntime_VM_element_specified_with_no_id_attribute_2);
        }
    }

    private static LibraryLocation getLibraryLocation(Element libLocationElement) {
        String jreJar = libLocationElement.getAttribute("jreJar");
        String jreSrc = libLocationElement.getAttribute("jreSrc");
        String pkgRoot = libLocationElement.getAttribute("pkgRoot");
        String jreJavadoc = libLocationElement.getAttribute("jreJavadoc");
        URL javadocURL = null;
        if (jreJavadoc.length() == 0) {
            jreJavadoc = null;
        } else {
            try {
                javadocURL = new URL(jreJavadoc);
            }
            catch (MalformedURLException malformedURLException) {
                LaunchingPlugin.log(LaunchingMessages.JavaRuntime_Library_location_element_incorrectly_specified_3);
            }
        }
        if (jreJar != null && jreSrc != null && pkgRoot != null) {
            return new LibraryLocation((IPath)new Path(jreJar), (IPath)new Path(jreSrc), (IPath)new Path(pkgRoot), javadocURL);
        }
        LaunchingPlugin.log(LaunchingMessages.JavaRuntime_Library_location_element_incorrectly_specified_3);
        return null;
    }

    private static void setLibraryLocations(IVMInstall vm, Element libLocationsElement) {
        NodeList list = libLocationsElement.getChildNodes();
        int length = list.getLength();
        ArrayList<LibraryLocation> locations = new ArrayList<LibraryLocation>(length);
        int i = 0;
        while (i < length) {
            Element libraryLocationElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (libraryLocationElement = (Element)node).getNodeName().equals("libraryLocation")) {
                locations.add(VMDefinitionsContainer.getLibraryLocation(libraryLocationElement));
            }
            ++i;
        }
        vm.setLibraryLocations(locations.toArray(new LibraryLocation[locations.size()]));
    }

    public void removeVM(IVMInstall vm) {
        this.fVMList.remove(vm);
        this.fInvalidVMList.remove(vm);
        List list = (List)this.fVMTypeToVMMap.get(vm.getVMInstallType());
        if (list != null) {
            list.remove(vm);
        }
    }
}

