/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

class ModificationStampValidationState
extends BufferValidationState {
    private BufferValidationState.ModificationStamp fModificationStamp = this.getModificationStamp();

    public ModificationStampValidationState(IFile file) {
        super(file);
    }

    public RefactoringStatus isValid(boolean needsSaving) throws CoreException {
        RefactoringStatus result = super.isValid(needsSaving);
        if (result.hasFatalError()) {
            return result;
        }
        BufferValidationState.ModificationStamp currentStamp = this.getModificationStamp();
        if (this.fModificationStamp.getValue() != currentStamp.getValue() || this.fModificationStamp.isFileStamp() && this.fModificationStamp.getValue() == -1L && !currentStamp.isFileStamp() || this.fModificationStamp.isDocumentStamp() && this.fModificationStamp.getValue() == -1L && !currentStamp.isDocumentStamp() || this.fModificationStamp.isFileStamp() && currentStamp.isFileStamp() && ModificationStampValidationState.isDirty(this.fFile)) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.TextChanges_error_content_changed, this.fFile.getFullPath().toString()));
        }
        return result;
    }
}

