/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.ltk.internal.core.refactoring.MultiStateUndoChange;
import org.eclipse.ltk.internal.core.refactoring.NonDeletingPositionUpdater;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public class MultiStateTextFileChange
extends TextEditBasedChange {
    private static final String COMPOSABLE_POSITION_CATEGORY = "ComposableEditPositionCategory_" + System.currentTimeMillis();
    private static final String MARKER_POSITION_CATEGORY = "MarkerPositionCategory_" + System.currentTimeMillis();
    private ITextFileBuffer fBuffer;
    private String fCachedString;
    private final ArrayList fChanges = new ArrayList(4);
    private ContentStamp fContentStamp;
    private TextEditCopier fCopier;
    private int fCount;
    private boolean fDirty;
    private IFile fFile;
    private int fSaveMode = 1;
    private BufferValidationState fValidationState;

    public MultiStateTextFileChange(String name, IFile file) {
        super(name);
        Assert.isNotNull((Object)file);
        this.fFile = file;
        this.setTextType("txt");
    }

    private IDocument acquireDocument(IProgressMonitor monitor) throws CoreException {
        if (this.fCount > 0) {
            return this.fBuffer.getDocument();
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = this.fFile.getFullPath();
        manager.connect(path, monitor);
        ++this.fCount;
        this.fBuffer = manager.getTextFileBuffer(path);
        IDocument document = this.fBuffer.getDocument();
        this.fContentStamp = ContentStamps.get(this.fFile, document);
        return document;
    }

    public final void addChange(TextChange change) {
        Assert.isNotNull((Object)change);
        ComposableBufferChange result = new ComposableBufferChange();
        result.setEdit(change.getEdit());
        TextEditBasedChangeGroup[] groups = change.getChangeGroups();
        ArrayList<ComposableBufferChangeGroup> list = new ArrayList<ComposableBufferChangeGroup>(groups.length);
        int index = 0;
        while (index < groups.length) {
            ComposableBufferChangeGroup group = new ComposableBufferChangeGroup(this, groups[index].getTextEditGroup());
            list.add(group);
            this.addChangeGroup(group);
            ++index;
        }
        result.setGroups(list);
        this.fChanges.add(result);
    }

    private TextEditProcessor createTextEditProcessor(ComposableBufferChange change, IDocument document, int flags, boolean preview) {
        ArrayList excludes = new ArrayList(0);
        for (TextEditBasedChangeGroup group : change.getGroups()) {
            if (group.isEnabled()) continue;
            excludes.addAll(Arrays.asList(group.getTextEdits()));
        }
        if (preview) {
            this.fCopier = new TextEditCopier(change.getEdit());
            TextEdit copiedEdit = this.fCopier.perform();
            boolean keep = this.getKeepPreviewEdits();
            if (keep) {
                flags |= 2;
            }
            TextEditBasedChange.LocalTextEditProcessor result = new TextEditBasedChange.LocalTextEditProcessor(document, copiedEdit, flags);
            result.setExcludes(this.mapEdits(excludes.toArray(new TextEdit[excludes.size()]), this.fCopier));
            if (!keep) {
                this.fCopier = null;
            }
            return result;
        }
        TextEditBasedChange.LocalTextEditProcessor result = new TextEditBasedChange.LocalTextEditProcessor(document, change.getEdit(), flags | 2);
        result.setExcludes(excludes.toArray(new TextEdit[excludes.size()]));
        return result;
    }

    private ReplaceEdit createUndoEdit(IDocument document, int offset, int length, String text) {
        String currentText = null;
        try {
            currentText = document.get(offset, length);
        }
        catch (BadLocationException badLocationException) {}
        if (this.fCachedString != null && this.fCachedString.equals(currentText)) {
            currentText = this.fCachedString;
        } else {
            this.fCachedString = currentText;
        }
        return new ReplaceEdit(offset, text != null ? text.length() : 0, currentText);
    }

    public final void dispose() {
        this.fValidationState.dispose();
    }

    public final String getCurrentContent(IProgressMonitor monitor) throws CoreException {
        return this.getCurrentDocument(monitor).get();
    }

    public final String getCurrentContent(IRegion region, boolean expand, int surround, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)region);
        Assert.isTrue((surround >= 0 ? 1 : 0) != 0);
        IDocument document = this.getCurrentDocument(monitor);
        Assert.isTrue((document.getLength() >= region.getOffset() + region.getLength() ? 1 : 0) != 0);
        return this.getContent(document, region, expand, surround);
    }

    public final IDocument getCurrentDocument(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IDocument result = null;
        monitor.beginTask("", 2);
        try {
            result = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            if (result != null) {
                this.releaseDocument(result, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        monitor.done();
        if (result == null) {
            result = new Document();
        }
        return result;
    }

    public final Object getModifiedElement() {
        return new Object[]{this.fFile};
    }

    public final String getPreviewContent(TextEditBasedChangeGroup[] groups, IRegion region, boolean expand, int surround, IProgressMonitor monitor) throws CoreException {
        HashSet cachedGroups = new HashSet(Arrays.asList(groups));
        Document document = new Document(this.getCurrentDocument(monitor).get());
        Position range = new Position(region.getOffset(), region.getLength());
        try {
            block49: {
                ComposableBufferChange change = null;
                final TextEditBasedChangeGroup[] changedGroups = this.getChangeGroups();
                LinkedList compositeUndo = new LinkedList();
                int index = 0;
                while (index < this.fChanges.size()) {
                    change = (ComposableBufferChange)this.fChanges.get(index);
                    TextEdit copy = null;
                    try {
                        this.fCopier = new TextEditCopier(change.getEdit());
                        copy = this.fCopier.perform();
                        final HashMap<TextEdit, TextEdit> originalMap = new HashMap<TextEdit, TextEdit>();
                        for (ComposableBufferChangeGroup group : change.getGroups()) {
                            for (TextEdit originalEdit : group.getCachedEdits()) {
                                TextEdit copiedEdit = this.fCopier.getCopy(originalEdit);
                                if (copiedEdit != null) {
                                    originalMap.put(copiedEdit, originalEdit);
                                    continue;
                                }
                                RefactoringCorePlugin.logErrorMessage("Could not find a copy for the indexed text edit " + originalEdit.toString());
                            }
                        }
                        final ComposableBufferChangeGroup[] currentGroup = new ComposableBufferChangeGroup[1];
                        final TextEdit[] currentEdit = new TextEdit[1];
                        TextEditProcessor processor = new TextEditProcessor((IDocument)document, copy, 0){

                            protected final boolean considerEdit(TextEdit edit) {
                                TextEdit originalEdit = (TextEdit)originalMap.get(edit);
                                if (originalEdit != null) {
                                    currentEdit[0] = originalEdit;
                                    boolean found = false;
                                    int offset = 0;
                                    while (offset < changedGroups.length && !found) {
                                        ComposableBufferChangeGroup group = (ComposableBufferChangeGroup)changedGroups[offset];
                                        if (group.containsEdit(originalEdit)) {
                                            currentGroup[0] = group;
                                            found = true;
                                        }
                                        ++offset;
                                    }
                                    if (!found) {
                                        currentGroup[0] = null;
                                    }
                                } else if (!(edit instanceof MultiTextEdit)) {
                                    RefactoringCorePlugin.logErrorMessage("Could not find the original of the copied text edit " + edit.toString());
                                }
                                return true;
                            }
                        };
                        LinkedList eventUndos = new LinkedList();
                        IDocumentListener listener = new IDocumentListener((IDocument)document, eventUndos){
                            private final /* synthetic */ IDocument val$document;
                            private final /* synthetic */ LinkedList val$eventUndos;
                            {
                                this.val$document = iDocument;
                                this.val$eventUndos = linkedList;
                            }

                            public final void documentAboutToBeChanged(DocumentEvent event) {
                                ComposableUndoEdit edit = new ComposableUndoEdit();
                                edit.setGroup(currentGroup[0]);
                                edit.setOriginal(currentEdit[0]);
                                edit.setUndo(MultiStateTextFileChange.this.createUndoEdit(this.val$document, event.getOffset(), event.getLength(), event.getText()));
                                this.val$eventUndos.addFirst(edit);
                            }

                            public final void documentChanged(DocumentEvent event) {
                            }
                        };
                        try {
                            document.addDocumentListener(listener);
                            processor.performEdits();
                        }
                        finally {
                            document.removeDocumentListener(listener);
                        }
                        compositeUndo.addFirst(eventUndos);
                    }
                    finally {
                        this.fCopier = null;
                    }
                    ++index;
                }
                IPositionUpdater positionUpdater = new IPositionUpdater(){

                    public final void update(DocumentEvent event) {
                        int eventOffset = event.getOffset();
                        int eventLength = event.getLength();
                        int eventOldEndOffset = eventOffset + eventLength;
                        String eventText = event.getText();
                        int eventNewLength = eventText == null ? 0 : eventText.length();
                        int eventNewEndOffset = eventOffset + eventNewLength;
                        int deltaLength = eventNewLength - eventLength;
                        try {
                            Position[] positions = event.getDocument().getPositions(COMPOSABLE_POSITION_CATEGORY);
                            int index = 0;
                            while (index < positions.length) {
                                Position position = positions[index];
                                if (!position.isDeleted()) {
                                    int offset = position.getOffset();
                                    int length = position.getLength();
                                    int end = offset + length;
                                    if (offset > eventOldEndOffset) {
                                        position.setOffset(offset + deltaLength);
                                    } else if (end >= eventOffset && offset != eventOffset) {
                                        if (offset <= eventOffset && end >= eventOldEndOffset) {
                                            position.setLength(length + deltaLength);
                                        } else if (offset < eventOffset) {
                                            position.setLength(eventNewEndOffset - offset);
                                        } else if (end > eventOldEndOffset) {
                                            position.setOffset(eventOffset);
                                            int deleted = eventOldEndOffset - offset;
                                            position.setLength(length - deleted + eventNewLength);
                                        } else {
                                            int newOffset = Math.min(offset, eventNewEndOffset);
                                            int newEndOffset = Math.min(end, eventNewEndOffset);
                                            position.setOffset(newOffset);
                                            position.setLength(newEndOffset - newOffset);
                                        }
                                    }
                                }
                                ++index;
                            }
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {}
                    }
                };
                try {
                    try {
                        NonDeletingPositionUpdater markerUpdater;
                        block48: {
                            document.addPositionCategory(COMPOSABLE_POSITION_CATEGORY);
                            document.addPositionUpdater(positionUpdater);
                            LinkedList<ComposableEditPosition> undoQueue = new LinkedList<ComposableEditPosition>();
                            Iterator outer = compositeUndo.iterator();
                            while (outer.hasNext()) {
                                for (ComposableUndoEdit edit : (List)outer.next()) {
                                    ReplaceEdit undo = edit.getUndo();
                                    int offset = undo.getOffset();
                                    int length = undo.getLength();
                                    String text = undo.getText();
                                    ComposableEditPosition position = new ComposableEditPosition();
                                    if (cachedGroups.contains(edit.getGroup())) {
                                        if (text == null || text.equals("")) {
                                            position.offset = offset;
                                            if (length != 0) {
                                                position.length = 0;
                                                position.setText(edit.getOriginalText());
                                            } else {
                                                RefactoringCorePlugin.logErrorMessage("Dubious undo edit found: " + undo.toString());
                                            }
                                        } else if (length == 0) {
                                            position.offset = offset;
                                            position.setText("");
                                            position.length = text.length();
                                        } else {
                                            position.offset = offset;
                                            position.length = length;
                                            position.setText(edit.getOriginalText());
                                        }
                                        document.addPosition(COMPOSABLE_POSITION_CATEGORY, (Position)position);
                                    }
                                    position = new ComposableEditPosition();
                                    position.offset = undo.getOffset();
                                    position.length = undo.getLength();
                                    position.setText(undo.getText());
                                    undoQueue.add(position);
                                }
                                Iterator iterator = undoQueue.iterator();
                                while (iterator.hasNext()) {
                                    ComposableEditPosition position = (ComposableEditPosition)((Object)iterator.next());
                                    document.replace(position.offset, position.length, position.getText());
                                    iterator.remove();
                                }
                            }
                            markerUpdater = new NonDeletingPositionUpdater(MARKER_POSITION_CATEGORY);
                            try {
                                try {
                                    Position[] positions = document.getPositions(COMPOSABLE_POSITION_CATEGORY);
                                    document.addPositionCategory(MARKER_POSITION_CATEGORY);
                                    document.addPositionUpdater((IPositionUpdater)markerUpdater);
                                    document.addPosition(MARKER_POSITION_CATEGORY, range);
                                    int index2 = 0;
                                    while (index2 < positions.length) {
                                        ComposableEditPosition position = (ComposableEditPosition)positions[index2];
                                        document.replace(position.offset, position.length, position.getText() != null ? position.getText() : "");
                                        ++index2;
                                    }
                                }
                                catch (BadPositionCategoryException exception) {
                                    RefactoringCorePlugin.log(exception);
                                    break block48;
                                }
                            }
                            catch (Throwable throwable) {
                                document.removePositionUpdater((IPositionUpdater)markerUpdater);
                                try {
                                    document.removePosition(MARKER_POSITION_CATEGORY, range);
                                    document.removePositionCategory(MARKER_POSITION_CATEGORY);
                                }
                                catch (BadPositionCategoryException badPositionCategoryException) {}
                                throw throwable;
                            }
                            document.removePositionUpdater((IPositionUpdater)markerUpdater);
                            try {
                                document.removePosition(MARKER_POSITION_CATEGORY, range);
                                document.removePositionCategory(MARKER_POSITION_CATEGORY);
                            }
                            catch (BadPositionCategoryException badPositionCategoryException) {}
                            break block49;
                        }
                        document.removePositionUpdater((IPositionUpdater)markerUpdater);
                        try {
                            document.removePosition(MARKER_POSITION_CATEGORY, range);
                            document.removePositionCategory(MARKER_POSITION_CATEGORY);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {
                        }
                    }
                    catch (BadPositionCategoryException exception) {
                        RefactoringCorePlugin.log(exception);
                    }
                }
                finally {
                    document.removePositionUpdater(positionUpdater);
                    try {
                        document.removePositionCategory(COMPOSABLE_POSITION_CATEGORY);
                    }
                    catch (BadPositionCategoryException exception) {
                        RefactoringCorePlugin.log(exception);
                    }
                }
            }
            return this.getContent((IDocument)document, (IRegion)new Region(range.offset, range.length), expand, surround);
        }
        catch (MalformedTreeException exception) {
            RefactoringCorePlugin.log(exception);
        }
        catch (BadLocationException exception) {
            RefactoringCorePlugin.log(exception);
        }
        return this.getPreviewDocument(monitor).get();
    }

    public final String getPreviewContent(IProgressMonitor monitor) throws CoreException {
        return this.getPreviewDocument(monitor).get();
    }

    public final IDocument getPreviewDocument(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        Document result = null;
        IDocument document = null;
        DocumentRewriteSession session = null;
        try {
            try {
                document = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (document != null) {
                    result = new Document(document.get());
                    if (result instanceof IDocumentExtension4) {
                        session = ((IDocumentExtension4)result).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                    }
                    this.performChanges((IDocument)result, null, true);
                }
            }
            catch (BadLocationException exception) {
                throw Changes.asCoreException(exception);
            }
        }
        finally {
            if (document != null) {
                try {
                    if (session != null && result != null) {
                        ((IDocumentExtension4)result).stopRewriteSession(session);
                    }
                }
                finally {
                    this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            monitor.done();
        }
        if (result == null) {
            result = new Document();
        }
        return result;
    }

    public final int getSaveMode() {
        return this.fSaveMode;
    }

    public final void initializeValidationData(IProgressMonitor monitor) {
        monitor.beginTask("", 1);
        this.fValidationState = BufferValidationState.create(this.fFile);
        monitor.worked(1);
    }

    public final RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        monitor.beginTask("", 1);
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath());
        this.fDirty = buffer != null && buffer.isDirty();
        RefactoringStatus status = this.fValidationState.isValid(this.needsSaving());
        if (this.needsSaving()) {
            status.merge(Changes.validateModifiesFiles(new IFile[]{this.fFile}));
        } else {
            status.merge(Changes.checkInSync(new IFile[]{this.fFile}));
        }
        monitor.worked(1);
        return status;
    }

    public final boolean needsSaving() {
        return (this.fSaveMode & 2) != 0 || !this.fDirty && (this.fSaveMode & 1) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Change perform(IProgressMonitor monitor) throws CoreException {
        MultiStateUndoChange multiStateUndoChange;
        block15: {
            monitor.beginTask("", 3);
            IDocument document = null;
            DocumentRewriteSession session = null;
            try {
                document = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (document instanceof IDocumentExtension4) {
                    session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                }
                LinkedList undoList = new LinkedList();
                this.performChanges(document, undoList, false);
                if (this.needsSaving()) {
                    this.fBuffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
                }
                multiStateUndoChange = new MultiStateUndoChange(this.getName(), this.fFile, undoList.toArray(new UndoEdit[undoList.size()]), this.fContentStamp, this.fSaveMode);
                if (document == null) break block15;
            }
            catch (BadLocationException exception) {
                try {
                    throw Changes.asCoreException(exception);
                }
                catch (Throwable throwable) {
                    if (document != null) {
                        try {
                            if (session != null) {
                                ((IDocumentExtension4)document).stopRewriteSession(session);
                            }
                        }
                        finally {
                            this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    monitor.done();
                    throw throwable;
                }
            }
            try {
                if (session != null) {
                    ((IDocumentExtension4)document).stopRewriteSession(session);
                }
            }
            finally {
                this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        monitor.done();
        return multiStateUndoChange;
    }

    private void performChanges(IDocument document, LinkedList undoList, boolean preview) throws BadLocationException {
        for (ComposableBufferChange change : this.fChanges) {
            UndoEdit edit = this.createTextEditProcessor(change, document, undoList != null ? 1 : 0, preview).performEdits();
            if (undoList == null) continue;
            undoList.addFirst(edit);
        }
    }

    private void releaseDocument(IDocument document, IProgressMonitor monitor) throws CoreException {
        Assert.isTrue((this.fCount > 0 ? 1 : 0) != 0);
        if (this.fCount == 1) {
            FileBuffers.getTextFileBufferManager().disconnect(this.fFile.getFullPath(), monitor);
        }
        --this.fCount;
    }

    public final void setKeepPreviewEdits(boolean keep) {
        super.setKeepPreviewEdits(keep);
        if (!keep) {
            this.fCopier = null;
        }
    }

    public final void setSaveMode(int mode) {
        this.fSaveMode = mode;
    }

    private static final class ComposableBufferChange {
        private TextEdit fEdit;
        private List fGroups;

        private ComposableBufferChange() {
        }

        private final TextEdit getEdit() {
            return this.fEdit;
        }

        private final List getGroups() {
            return this.fGroups;
        }

        private final void setEdit(TextEdit edit) {
            Assert.isNotNull((Object)edit);
            this.fEdit = edit;
        }

        private final void setGroups(List groups) {
            Assert.isNotNull((Object)groups);
            this.fGroups = groups;
        }
    }

    private static final class ComposableBufferChangeGroup
    extends TextEditBasedChangeGroup {
        private final Set fEdits = new HashSet();

        private ComposableBufferChangeGroup(MultiStateTextFileChange change, TextEditGroup group) {
            super(change, group);
            TextEdit[] edits = group.getTextEdits();
            int index = 0;
            while (index < edits.length) {
                this.cacheEdit(edits[index]);
                ++index;
            }
        }

        private final void cacheEdit(TextEdit edit) {
            this.fEdits.add(edit);
            TextEdit[] edits = edit.getChildren();
            int index = 0;
            while (index < edits.length) {
                this.cacheEdit(edits[index]);
                ++index;
            }
        }

        private final boolean containsEdit(TextEdit edit) {
            return this.fEdits.contains(edit);
        }

        private final Set getCachedEdits() {
            return this.fEdits;
        }
    }

    private static final class ComposableEditPosition
    extends Position {
        private String fText;

        private ComposableEditPosition() {
        }

        private final String getText() {
            return this.fText;
        }

        private final void setText(String text) {
            Assert.isNotNull((Object)text);
            this.fText = text;
        }
    }

    private static final class ComposableUndoEdit {
        private ComposableBufferChangeGroup fGroup;
        private TextEdit fOriginal;
        private ReplaceEdit fUndo;

        private ComposableUndoEdit() {
        }

        private final ComposableBufferChangeGroup getGroup() {
            return this.fGroup;
        }

        private final TextEdit getOriginal() {
            return this.fOriginal;
        }

        private final String getOriginalText() {
            if (this.fOriginal instanceof ReplaceEdit) {
                return ((ReplaceEdit)this.getOriginal()).getText();
            }
            if (this.fOriginal instanceof InsertEdit) {
                return ((InsertEdit)this.getOriginal()).getText();
            }
            return "";
        }

        private final ReplaceEdit getUndo() {
            return this.fUndo;
        }

        private final void setGroup(ComposableBufferChangeGroup group) {
            Assert.isNotNull((Object)group);
            this.fGroup = group;
        }

        private final void setOriginal(TextEdit edit) {
            this.fOriginal = edit;
        }

        private final void setUndo(ReplaceEdit undo) {
            Assert.isNotNull((Object)undo);
            this.fUndo = undo;
        }
    }
}

