/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractIntegerRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.RenderingsUtil;
import org.eclipse.debug.ui.IDebugUIConstants;

public class SignedIntegerRendering
extends AbstractIntegerRendering {
    private int fColSize;
    private BigInteger fMax;
    private BigInteger fMin;

    public SignedIntegerRendering(String renderingId) {
        super(renderingId);
    }

    private String convertToString(byte[] byteArray, int columnSize, int endianess) {
        long result = 0L;
        if (columnSize == 1) {
            result = byteArray[0];
        } else if (columnSize == 2) {
            result = RenderingsUtil.convertByteArrayToShort(byteArray, endianess);
        } else if (columnSize == 4) {
            result = RenderingsUtil.convertByteArrayToInt(byteArray, endianess);
        } else if (columnSize == 8) {
            result = RenderingsUtil.convertByteArrayToLong(byteArray, endianess);
        } else {
            if (columnSize == 16) {
                BigInteger bigRet = RenderingsUtil.convertByteArrayToSignedBigInt(byteArray, endianess);
                return bigRet.toString();
            }
            BigInteger bigRet = RenderingsUtil.convertByteArrayToSignedBigInt(byteArray, endianess, columnSize);
            return bigRet.toString();
        }
        String ret = new Long(result).toString();
        return ret;
    }

    private byte[] convertToBytes(int colSize, String newValue, int endianess) {
        byte[] bytes;
        if (colSize == 1) {
            byte x = Byte.parseByte(newValue);
            bytes = new byte[]{x};
        } else if (colSize == 2) {
            short i = Short.parseShort(newValue);
            bytes = RenderingsUtil.convertShortToByteArray(i, endianess);
        } else if (colSize == 4) {
            int i = Integer.parseInt(newValue);
            bytes = RenderingsUtil.convertIntToByteArray(i, endianess);
        } else if (colSize == 8) {
            long i = Long.parseLong(newValue);
            bytes = RenderingsUtil.convertLongToByteArray(i, endianess);
        } else {
            if (colSize == 16) {
                BigInteger i = new BigInteger(newValue);
                byte[] bytes2 = RenderingsUtil.convertBigIntegerToByteArray(i, endianess);
                return bytes2;
            }
            BigInteger i = new BigInteger(newValue);
            if (this.fColSize != colSize) {
                this.fColSize = colSize;
                this.fMax = BigInteger.valueOf(2L);
                this.fMax = this.fMax.pow(colSize * 8 - 1);
                this.fMin = this.fMax.multiply(BigInteger.valueOf(-1L));
                this.fMax = this.fMax.subtract(BigInteger.valueOf(1L));
            }
            if (i.compareTo(this.fMax) > 0 || i.compareTo(this.fMin) < 0) {
                throw new NumberFormatException();
            }
            byte[] bytes3 = RenderingsUtil.convertSignedBigIntToByteArray(i, endianess, colSize);
            return bytes3;
        }
        return bytes;
    }

    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        boolean invalid = false;
        String paddedStr = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_PADDED_STR);
        int i = 0;
        while (i < data.length) {
            if (!data[i].isReadable()) {
                invalid = true;
                break;
            }
            ++i;
        }
        if (invalid) {
            StringBuffer strBuf = new StringBuffer();
            int i2 = 0;
            while (i2 < data.length) {
                strBuf.append(paddedStr);
                ++i2;
            }
            return strBuf.toString();
        }
        int columnSize = this.getBytesPerColumn();
        int endianess = this.getDisplayEndianess();
        if (endianess == 2) {
            endianess = this.getBytesEndianess(data);
        }
        byte[] byteArray = new byte[data.length];
        int i3 = 0;
        while (i3 < byteArray.length) {
            byteArray[i3] = data[i3].getValue();
            ++i3;
        }
        if (2 == endianess) {
            StringBuffer strBuf = new StringBuffer();
            int i4 = 0;
            while (i4 < byteArray.length) {
                strBuf.append(paddedStr);
                ++i4;
            }
            return strBuf.toString();
        }
        return this.convertToString(byteArray, columnSize, endianess);
    }

    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        int columnSize = this.getBytesPerColumn();
        int endianess = this.getDisplayEndianess();
        if (endianess == 2) {
            endianess = this.getBytesEndianess(currentValues);
        }
        if (endianess == 2) {
            byte[] retBytes = new byte[currentValues.length];
            int i = 0;
            while (i < currentValues.length) {
                retBytes[i] = currentValues[i].getValue();
                ++i;
            }
            return retBytes;
        }
        return this.convertToBytes(columnSize, data, endianess);
    }
}

