/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MonitorMemoryBlockDialog
extends TrayDialog
implements ModifyListener {
    private Combo expressionInput;
    private Text lengthInput;
    private String expression;
    private String length;
    private boolean needLength = true;
    private String fPrefillExp = null;
    private String fPrefillLength = null;

    public MonitorMemoryBlockDialog(Shell parentShell, IMemoryBlockRetrieval memRetrieval, String prefillExp, String prefillLength) {
        super(parentShell);
        if (memRetrieval instanceof IMemoryBlockRetrievalExtension) {
            this.needLength = false;
        }
        this.fPrefillExp = prefillExp;
        this.fPrefillLength = prefillLength;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MonitorMemoryBlockDialog_context");
        parent.setLayout((Layout)new GridLayout());
        GridData spec2 = new GridData();
        spec2.grabExcessVerticalSpace = true;
        spec2.grabExcessHorizontalSpace = true;
        spec2.horizontalAlignment = 4;
        spec2.verticalAlignment = 2;
        parent.setLayoutData((Object)spec2);
        Label textLabel = new Label(parent, 0);
        textLabel.setText(DebugUIMessages.MonitorMemoryBlockDialog_EnterExpressionToMonitor);
        GridData textLayout = new GridData();
        textLabel.setLayoutData((Object)textLayout);
        this.expressionInput = new Combo(parent, 2048);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        this.expressionInput.setLayoutData((Object)spec);
        String[] historyExpression = MemoryViewUtil.getHistory();
        int i = 0;
        while (i < historyExpression.length) {
            this.expressionInput.add(historyExpression[i]);
            ++i;
        }
        if (this.fPrefillExp != null) {
            this.expressionInput.setText(this.fPrefillExp);
        }
        this.expressionInput.addModifyListener((ModifyListener)this);
        if (this.needLength) {
            Label lengthLabel = new Label(parent, 0);
            lengthLabel.setText(DebugUIMessages.MonitorMemoryBlockDialog_NumberOfBytes);
            GridData lengthLayout = new GridData();
            lengthLabel.setLayoutData((Object)lengthLayout);
            this.lengthInput = new Text(parent, 2048);
            GridData lengthSpec = new GridData();
            lengthSpec.grabExcessVerticalSpace = false;
            lengthSpec.grabExcessHorizontalSpace = true;
            lengthSpec.horizontalAlignment = 4;
            this.lengthInput.setLayoutData((Object)lengthSpec);
            if (this.fPrefillLength != null) {
                this.lengthInput.setText(this.fPrefillLength);
            }
            this.lengthInput.addModifyListener((ModifyListener)this);
        }
        return parent;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DebugUIMessages.MonitorMemoryBlockDialog_MonitorMemory);
    }

    public String getExpression() {
        return this.expression;
    }

    public String getLength() {
        return this.length;
    }

    protected void okPressed() {
        this.expression = this.expressionInput.getText();
        MemoryViewUtil.addHistory(this.expression);
        if (this.needLength) {
            this.length = this.lengthInput.getText();
        }
        super.okPressed();
    }

    public void modifyText(ModifyEvent e) {
        this.updateOKButtonState();
    }

    private void updateOKButtonState() {
        if (this.needLength) {
            String lengthText = this.lengthInput.getText();
            String input = this.expressionInput.getText();
            if (input == null || input.equals("") || lengthText == null || lengthText.equals("")) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control ret = super.createButtonBar(parent);
        if (this.needLength) {
            this.updateOKButtonState();
        } else {
            this.getButton(0).setEnabled(true);
        }
        return ret;
    }
}

