/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class MemoryRetrievalProxy
extends AbstractModelProxy
implements IMemoryBlockListener {
    private IMemoryBlockRetrieval fRetrieval;

    public MemoryRetrievalProxy(IMemoryBlockRetrieval retrieval) {
        this.fRetrieval = retrieval;
    }

    public void memoryBlocksAdded(IMemoryBlock[] memory) {
        ModelDelta delta = new ModelDelta(this.fRetrieval, 0);
        int i = 0;
        while (i < memory.length) {
            IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)memory[i].getAdapter(IMemoryBlockRetrieval.class);
            if (retrieval == null) {
                retrieval = memory[i].getDebugTarget();
            }
            if (retrieval != null && retrieval == this.fRetrieval) {
                delta.addNode(memory[i], 0x200001);
            }
            ++i;
        }
        this.fireModelChanged(delta);
    }

    public void memoryBlocksRemoved(IMemoryBlock[] memory) {
        ModelDelta delta = new ModelDelta(this.fRetrieval, 0);
        int i = 0;
        while (i < memory.length) {
            IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)memory[i].getAdapter(IMemoryBlockRetrieval.class);
            if (retrieval == null) {
                retrieval = memory[i].getDebugTarget();
            }
            if (retrieval != null && retrieval == this.fRetrieval) {
                if (this.isMemoryBlockSelected(this.getCurrentSelection(), memory[i])) {
                    this.addSelectDeltaNode(delta);
                }
                delta.addNode(memory[i], 2);
            }
            ++i;
        }
        this.fireModelChanged(delta);
    }

    public void init(IPresentationContext context) {
        super.init(context);
        DebugPlugin.getDefault().getMemoryBlockManager().addListener((IMemoryBlockListener)this);
    }

    public synchronized void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
    }

    private void addSelectDeltaNode(ModelDelta delta) {
        IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fRetrieval);
        if (memoryBlocks != null && memoryBlocks.length > 0) {
            delta.addNode(memoryBlocks[0], 0x200000);
        }
    }

    private IStructuredSelection getCurrentSelection() {
        if (this.getPresentationContext() == null) {
            return StructuredSelection.EMPTY;
        }
        ISelection selection = this.getPresentationContext().getPart().getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private boolean isMemoryBlockSelected(IStructuredSelection selection, IMemoryBlock memoryBlock) {
        if (!selection.isEmpty()) {
            for (Object sel : selection) {
                if (sel == memoryBlock) {
                    return true;
                }
                if (!(sel instanceof IMemoryRendering) || ((IMemoryRendering)sel).getMemoryBlock() != memoryBlock) continue;
                return true;
            }
        }
        return false;
    }
}

