/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DefaultExpressionModelProxy;

public class ExpressionEventHandler
extends DebugEventHandler {
    public ExpressionEventHandler(AbstractModelProxy proxy) {
        super(proxy);
    }

    protected boolean handlesEvent(DebugEvent event) {
        return event.getKind() == 16;
    }

    protected void handleChange(DebugEvent event) {
        ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getExpressionManager(), 0);
        IExpression expression = null;
        if (event.getSource() instanceof IExpression) {
            expression = (IExpression)event.getSource();
        } else {
            AbstractModelProxy modelProxy = this.getModelProxy();
            if (modelProxy instanceof DefaultExpressionModelProxy) {
                DefaultExpressionModelProxy proxy = (DefaultExpressionModelProxy)modelProxy;
                expression = proxy.getExpression();
            }
        }
        if (expression != null) {
            delta.addNode(expression, 3072);
            this.fireDelta(delta);
        }
    }

    protected void refreshRoot(DebugEvent event) {
        ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getExpressionManager(), 1024);
        this.fireDelta(delta);
    }
}

