/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.internal.ObjectContributorManager;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;
import org.eclipse.ui.internal.registry.PropertyPagesRegistryReader;

public class PropertyPageContributorManager
extends ObjectContributorManager {
    private static PropertyPageContributorManager sharedInstance = null;
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            CategorizedPageNode c1 = (CategorizedPageNode)arg0;
            CategorizedPageNode c2 = (CategorizedPageNode)arg1;
            if ("org.eclipse.ui.propertypages.info.file".equals(c1.contributor.getPageId())) {
                if ("org.eclipse.ui.propertypages.info.file".equals(c2.contributor.getPageId())) {
                    return 0;
                }
                return -1;
            }
            if ("org.eclipse.ui.propertypages.info.file".equals(c2.contributor.getPageId())) {
                return 1;
            }
            String s1 = c1.getQualifiedName();
            String s2 = c2.getQualifiedName();
            return this.collator.compare(s1, s2);
        }
    };

    public PropertyPageContributorManager() {
        this.loadContributors();
    }

    public boolean contribute(PropertyPageManager manager, Object object) {
        List result = this.getContributors(object);
        if (result == null || result.size() == 0) {
            return false;
        }
        List sortedResult = this.buildNodeList(result);
        Collections.sort(sortedResult, comparer);
        Iterator resultIterator = sortedResult.iterator();
        boolean actualContributions = false;
        while (resultIterator.hasNext()) {
            int i = 0;
            while (i < sortedResult.size()) {
                CategorizedPageNode next = (CategorizedPageNode)resultIterator.next();
                RegistryPageContributor ppcont = next.contributor;
                if (ppcont.isApplicableTo(object) && ppcont.contributePropertyPages(manager, object)) {
                    actualContributions = true;
                }
                ++i;
            }
        }
        return actualContributions;
    }

    private List buildNodeList(List nodes) {
        Hashtable<String, CategorizedPageNode> mapping = new Hashtable<String, CategorizedPageNode>();
        for (RegistryPageContributor page : nodes) {
            mapping.put(page.getPageId(), new CategorizedPageNode(page));
        }
        Iterator values = mapping.values().iterator();
        ArrayList<CategorizedPageNode> returnValue = new ArrayList<CategorizedPageNode>();
        while (values.hasNext()) {
            Object parent;
            CategorizedPageNode next = (CategorizedPageNode)values.next();
            returnValue.add(next);
            if (next.contributor.getCategory() == null || (parent = mapping.get(next.contributor.getCategory())) == null) continue;
            next.setParent((CategorizedPageNode)parent);
        }
        return returnValue;
    }

    public static PropertyPageContributorManager getManager() {
        if (sharedInstance == null) {
            sharedInstance = new PropertyPageContributorManager();
        }
        return sharedInstance;
    }

    private void loadContributors() {
        PropertyPagesRegistryReader reader = new PropertyPagesRegistryReader(this);
        reader.registerPropertyPages(Platform.getExtensionRegistry());
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] addedElements = extension.getConfigurationElements();
        int i = 0;
        while (i < addedElements.length) {
            PropertyPagesRegistryReader reader = new PropertyPagesRegistryReader(this);
            reader.readElement(addedElements[i]);
            ++i;
        }
    }

    public Collection getApplicableContributors(Object element) {
        List contributors = this.getContributors(element);
        ArrayList<RegistryPageContributor> result = new ArrayList<RegistryPageContributor>();
        for (RegistryPageContributor contributor : contributors) {
            if (!contributor.isApplicableTo(element)) continue;
            result.add(contributor);
        }
        return result;
    }

    private class CategorizedPageNode {
        RegistryPageContributor contributor;
        CategorizedPageNode parent;
        String qualifiedName;

        CategorizedPageNode(RegistryPageContributor page) {
            this.contributor = page;
        }

        void setParent(CategorizedPageNode node) {
            this.parent = node;
        }

        String getQualifiedName() {
            if (this.qualifiedName == null) {
                if (this.parent == null) {
                    this.qualifiedName = this.contributor.getPageName();
                } else {
                    StringBuffer nameBuffer = new StringBuffer();
                    nameBuffer.append(this.parent.getQualifiedName());
                    nameBuffer.append(WorkbenchPlugin.PREFERENCE_PAGE_CATEGORY_SEPARATOR);
                    nameBuffer.append(this.contributor.getPageName());
                    this.qualifiedName = nameBuffer.toString();
                }
            }
            return this.qualifiedName;
        }
    }
}

