/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IExecutionListenerWithChecks;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IObjectWithState;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ITypedParameter;
import org.eclipse.core.commands.NamedHandleObjectWithState;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.internal.commands.util.Util;
import org.eclipse.core.runtime.ListenerList;

public final class Command
extends NamedHandleObjectWithState
implements Comparable {
    public static boolean DEBUG_COMMAND_EXECUTION = false;
    public static boolean DEBUG_HANDLERS = false;
    public static String DEBUG_HANDLERS_COMMAND_ID = null;
    private Category category = null;
    private transient ListenerList executionListeners = null;
    private transient IHandler handler = null;
    private String helpContextId;
    private IParameter[] parameters = null;
    private ParameterType returnType = null;

    Command(String id) {
        super(id);
    }

    public final void addCommandListener(ICommandListener commandListener) {
        if (commandListener == null) {
            throw new NullPointerException("Cannot add a null command listener");
        }
        this.addListenerObject(commandListener);
    }

    public final void addExecutionListener(IExecutionListener executionListener) {
        if (executionListener == null) {
            throw new NullPointerException("Cannot add a null execution listener");
        }
        if (this.executionListeners == null) {
            this.executionListeners = new ListenerList(1);
        }
        this.executionListeners.add((Object)executionListener);
    }

    public void addState(String id, State state) {
        super.addState(id, state);
        state.setId(id);
        if (this.handler instanceof IObjectWithState) {
            ((IObjectWithState)((Object)this.handler)).addState(id, state);
        }
    }

    public final int compareTo(Object object) {
        Command castedObject = (Command)object;
        int compareTo = Util.compare(this.category, castedObject.category);
        if (compareTo == 0 && (compareTo = Util.compare(this.defined, castedObject.defined)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)castedObject.description))) == 0 && (compareTo = Util.compare(this.handler, castedObject.handler)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id))) == 0 && (compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)castedObject.name))) == 0) {
            compareTo = Util.compare(this.parameters, castedObject.parameters);
        }
        return compareTo;
    }

    public final void define(String name, String description, Category category) {
        this.define(name, description, category, null);
    }

    public final void define(String name, String description, Category category, IParameter[] parameters) {
        this.define(name, description, category, parameters, null);
    }

    public final void define(String name, String description, Category category, IParameter[] parameters, ParameterType returnType) {
        this.define(name, description, category, parameters, returnType, null);
    }

    public final void define(String name, String description, Category category, IParameter[] parameters, ParameterType returnType, String helpContextId) {
        if (name == null) {
            throw new NullPointerException("The name of a command cannot be null");
        }
        if (category == null) {
            throw new NullPointerException("The category of a command cannot be null");
        }
        boolean definedChanged = !this.defined;
        this.defined = true;
        boolean nameChanged = !Util.equals(this.name, name);
        this.name = name;
        boolean descriptionChanged = !Util.equals(this.description, description);
        this.description = description;
        boolean categoryChanged = !Util.equals(this.category, category);
        this.category = category;
        boolean parametersChanged = !Util.equals(this.parameters, parameters);
        this.parameters = parameters;
        boolean returnTypeChanged = !Util.equals(this.returnType, returnType);
        this.returnType = returnType;
        boolean helpContextIdChanged = !Util.equals(this.helpContextId, helpContextId);
        this.helpContextId = helpContextId;
        this.fireCommandChanged(new CommandEvent(this, categoryChanged, definedChanged, descriptionChanged, false, nameChanged, parametersChanged, returnTypeChanged, helpContextIdChanged));
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException, NotHandledException {
        this.firePreExecute(event);
        IHandler handler = this.handler;
        if (handler != null && handler.isHandled()) {
            try {
                Object returnValue = handler.execute(event);
                this.firePostExecuteSuccess(returnValue);
                return returnValue;
            }
            catch (ExecutionException e) {
                this.firePostExecuteFailure(e);
                throw e;
            }
        }
        NotHandledException e = new NotHandledException("There is no handler to execute.");
        this.fireNotHandled(e);
        throw e;
    }

    public final Object executeWithChecks(ExecutionEvent event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.firePreExecute(event);
        IHandler handler = this.handler;
        if (!this.isDefined()) {
            NotDefinedException exception = new NotDefinedException("Trying to execute a command that is not defined. " + this.id);
            this.fireNotDefined(exception);
            throw exception;
        }
        if (handler != null && handler.isHandled()) {
            if (!this.isEnabled()) {
                NotEnabledException exception = new NotEnabledException("Trying to execute a disabled command");
                this.fireNotEnabled(exception);
                throw exception;
            }
            try {
                Object returnValue = handler.execute(event);
                this.firePostExecuteSuccess(returnValue);
                return returnValue;
            }
            catch (ExecutionException e) {
                this.firePostExecuteFailure(e);
                throw e;
            }
        }
        NotHandledException e = new NotHandledException("There is no handler to execute.");
        this.fireNotHandled(e);
        throw e;
    }

    private final void fireCommandChanged(CommandEvent commandEvent) {
        if (commandEvent == null) {
            throw new NullPointerException("Cannot fire a null event");
        }
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ICommandListener listener = (ICommandListener)listeners[i];
            listener.commandChanged(commandEvent);
            ++i;
        }
    }

    private final void fireNotDefined(NotDefinedException e) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> not defined: id=" + this.getId() + "; exception=" + e);
        }
        if (this.executionListeners != null) {
            Object[] listeners = this.executionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                Object object = listeners[i];
                if (object instanceof IExecutionListenerWithChecks) {
                    IExecutionListenerWithChecks listener = (IExecutionListenerWithChecks)object;
                    listener.notDefined(this.getId(), e);
                }
                ++i;
            }
        }
    }

    private final void fireNotEnabled(NotEnabledException e) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> not enabled: id=" + this.getId() + "; exception=" + e);
        }
        if (this.executionListeners != null) {
            Object[] listeners = this.executionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                Object object = listeners[i];
                if (object instanceof IExecutionListenerWithChecks) {
                    IExecutionListenerWithChecks listener = (IExecutionListenerWithChecks)object;
                    listener.notEnabled(this.getId(), e);
                }
                ++i;
            }
        }
    }

    private final void fireNotHandled(NotHandledException e) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> not handled: id=" + this.getId() + "; exception=" + e);
        }
        if (this.executionListeners != null) {
            Object[] listeners = this.executionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IExecutionListener listener = (IExecutionListener)listeners[i];
                listener.notHandled(this.getId(), e);
                ++i;
            }
        }
    }

    private final void firePostExecuteFailure(ExecutionException e) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> failure: id=" + this.getId() + "; exception=" + e);
        }
        if (this.executionListeners != null) {
            Object[] listeners = this.executionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IExecutionListener listener = (IExecutionListener)listeners[i];
                listener.postExecuteFailure(this.getId(), e);
                ++i;
            }
        }
    }

    private final void firePostExecuteSuccess(Object returnValue) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> success: id=" + this.getId() + "; returnValue=" + returnValue);
        }
        if (this.executionListeners != null) {
            Object[] listeners = this.executionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IExecutionListener listener = (IExecutionListener)listeners[i];
                listener.postExecuteSuccess(this.getId(), returnValue);
                ++i;
            }
        }
    }

    private final void firePreExecute(ExecutionEvent event) {
        if (DEBUG_COMMAND_EXECUTION) {
            Tracing.printTrace("COMMANDS", "execute >>> starting: id=" + this.getId() + "; event=" + event);
        }
        if (this.executionListeners != null) {
            Object[] listeners = this.executionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IExecutionListener listener = (IExecutionListener)listeners[i];
                listener.preExecute(this.getId(), event);
                ++i;
            }
        }
    }

    public final Category getCategory() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the category from an undefined command. " + this.id);
        }
        return this.category;
    }

    final IHandler getHandler() {
        return this.handler;
    }

    final String getHelpContextId() {
        return this.helpContextId;
    }

    public final IParameter getParameter(String parameterId) throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get a parameter from an undefined command. " + this.id);
        }
        if (this.parameters == null) {
            return null;
        }
        int i = 0;
        while (i < this.parameters.length) {
            IParameter parameter = this.parameters[i];
            if (parameter.getId().equals(parameterId)) {
                return parameter;
            }
            ++i;
        }
        return null;
    }

    public final IParameter[] getParameters() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the parameters from an undefined command. " + this.id);
        }
        if (this.parameters == null || this.parameters.length == 0) {
            return null;
        }
        IParameter[] returnValue = new IParameter[this.parameters.length];
        System.arraycopy(this.parameters, 0, returnValue, 0, this.parameters.length);
        return returnValue;
    }

    public final ParameterType getParameterType(String parameterId) throws NotDefinedException {
        IParameter parameter = this.getParameter(parameterId);
        if (parameter instanceof ITypedParameter) {
            ITypedParameter parameterWithType = (ITypedParameter)((Object)parameter);
            return parameterWithType.getParameterType();
        }
        return null;
    }

    public final ParameterType getReturnType() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the return type of an undefined command. " + this.id);
        }
        return this.returnType;
    }

    public final boolean isEnabled() {
        if (this.handler == null) {
            return false;
        }
        return this.handler.isHandled() && this.handler.isEnabled();
    }

    public final boolean isHandled() {
        if (this.handler == null) {
            return false;
        }
        return this.handler.isHandled();
    }

    public final void removeCommandListener(ICommandListener commandListener) {
        if (commandListener == null) {
            throw new NullPointerException("Cannot remove a null command listener");
        }
        this.removeListenerObject(commandListener);
    }

    public final void removeExecutionListener(IExecutionListener executionListener) {
        if (executionListener == null) {
            throw new NullPointerException("Cannot remove a null execution listener");
        }
        if (this.executionListeners != null) {
            this.executionListeners.remove((Object)executionListener);
            if (this.executionListeners.isEmpty()) {
                this.executionListeners = null;
            }
        }
    }

    public void removeState(String stateId) {
        if (this.handler instanceof IObjectWithState) {
            ((IObjectWithState)((Object)this.handler)).removeState(stateId);
        }
        super.removeState(stateId);
    }

    public final boolean setHandler(IHandler handler) {
        if (Util.equals(handler, this.handler)) {
            return false;
        }
        String[] stateIds = this.getStateIds();
        if (stateIds != null) {
            int i = 0;
            while (i < stateIds.length) {
                String stateId = stateIds[i];
                if (this.handler instanceof IObjectWithState) {
                    ((IObjectWithState)((Object)this.handler)).removeState(stateId);
                }
                if (handler instanceof IObjectWithState) {
                    State stateToAdd = this.getState(stateId);
                    ((IObjectWithState)((Object)handler)).addState(stateId, stateToAdd);
                }
                ++i;
            }
        }
        this.handler = handler;
        this.string = null;
        if (DEBUG_HANDLERS && (DEBUG_HANDLERS_COMMAND_ID == null || DEBUG_HANDLERS_COMMAND_ID.equals(this.id))) {
            StringBuffer buffer = new StringBuffer("Command('");
            buffer.append(this.id);
            buffer.append("') has changed to ");
            if (handler == null) {
                buffer.append("no handler");
            } else {
                buffer.append('\'');
                buffer.append(handler);
                buffer.append("' as its handler");
            }
            Tracing.printTrace("HANDLERS", buffer.toString());
        }
        this.fireCommandChanged(new CommandEvent(this, false, false, false, true, false, false, false));
        return true;
    }

    public final String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Command(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.category);
            stringBuffer.append(',');
            stringBuffer.append(this.handler);
            stringBuffer.append(',');
            stringBuffer.append(this.parameters);
            stringBuffer.append(',');
            stringBuffer.append(this.returnType);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final void undefine() {
        this.string = null;
        boolean definedChanged = this.defined;
        this.defined = false;
        boolean nameChanged = this.name != null;
        this.name = null;
        boolean descriptionChanged = this.description != null;
        this.description = null;
        boolean categoryChanged = this.category != null;
        this.category = null;
        boolean parametersChanged = this.parameters != null;
        this.parameters = null;
        boolean returnTypeChanged = this.returnType != null;
        this.returnType = null;
        String[] stateIds = this.getStateIds();
        if (stateIds != null) {
            if (this.handler instanceof IObjectWithState) {
                IObjectWithState handlerWithState = (IObjectWithState)((Object)this.handler);
                int i = 0;
                while (i < stateIds.length) {
                    String stateId = stateIds[i];
                    handlerWithState.removeState(stateId);
                    State state = this.getState(stateId);
                    this.removeState(stateId);
                    state.dispose();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < stateIds.length) {
                    String stateId = stateIds[i];
                    State state = this.getState(stateId);
                    this.removeState(stateId);
                    state.dispose();
                    ++i;
                }
            }
        }
        this.fireCommandChanged(new CommandEvent(this, categoryChanged, definedChanged, descriptionChanged, false, nameChanged, parametersChanged, returnTypeChanged));
    }
}

