/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.Properties;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs.util.Os;

public class SftpClientFactory {
    private static final String SSH_DIR_NAME = ".ssh";

    private SftpClientFactory() {
    }

    public static Session createConnection(String hostname, int port, char[] username, char[] password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        Session session;
        JSch jsch = new JSch();
        File sshDir = null;
        File knownHostsFile = SftpFileSystemConfigBuilder.getInstance().getKnownHosts(fileSystemOptions);
        File[] identities = SftpFileSystemConfigBuilder.getInstance().getIdentities(fileSystemOptions);
        if (knownHostsFile != null) {
            try {
                jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
            }
            catch (JSchException e) {
                throw new FileSystemException("vfs.provider.sftp/known-hosts.error", knownHostsFile.getAbsolutePath(), (Throwable)e);
            }
        }
        if (sshDir == null) {
            sshDir = SftpClientFactory.findSshDir();
        }
        if ((knownHostsFile = new File(sshDir, "known_hosts")).isFile() && knownHostsFile.canRead()) {
            try {
                jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
            }
            catch (JSchException e) {
                throw new FileSystemException("vfs.provider.sftp/known-hosts.error", knownHostsFile.getAbsolutePath(), (Throwable)e);
            }
        }
        if (identities != null) {
            for (int iterIdentities = 0; iterIdentities < identities.length; ++iterIdentities) {
                File privateKeyFile = identities[iterIdentities];
                try {
                    jsch.addIdentity(privateKeyFile.getAbsolutePath());
                    continue;
                }
                catch (JSchException e) {
                    throw new FileSystemException("vfs.provider.sftp/load-private-key.error", privateKeyFile, (Throwable)e);
                }
            }
        } else {
            File privateKeyFile;
            if (sshDir == null) {
                sshDir = SftpClientFactory.findSshDir();
            }
            if ((privateKeyFile = new File(sshDir, "id_rsa")).isFile() && privateKeyFile.canRead()) {
                try {
                    jsch.addIdentity(privateKeyFile.getAbsolutePath());
                }
                catch (JSchException e) {
                    throw new FileSystemException("vfs.provider.sftp/load-private-key.error", privateKeyFile, (Throwable)e);
                }
            }
        }
        try {
            String compression;
            UserInfo userInfo;
            session = jsch.getSession(new String(username), hostname, port);
            session.setPassword(new String(password));
            Integer timeout = SftpFileSystemConfigBuilder.getInstance().getTimeout(fileSystemOptions);
            if (timeout != null) {
                session.setTimeout(timeout.intValue());
            }
            if ((userInfo = SftpFileSystemConfigBuilder.getInstance().getUserInfo(fileSystemOptions)) != null) {
                session.setUserInfo(userInfo);
            }
            Properties config = new Properties();
            String strictHostKeyChecking = SftpFileSystemConfigBuilder.getInstance().getStrictHostKeyChecking(fileSystemOptions);
            if (strictHostKeyChecking != null) {
                config.setProperty("StrictHostKeyChecking", strictHostKeyChecking);
            }
            if ((compression = SftpFileSystemConfigBuilder.getInstance().getCompression(fileSystemOptions)) != null) {
                config.setProperty("compression.s2c", strictHostKeyChecking);
                config.setProperty("compression.c2s", strictHostKeyChecking);
            }
            if (config.size() > 0) {
                session.setConfig(config);
            }
            session.connect();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", new Object[]{hostname}, (Throwable)exc);
        }
        return session;
    }

    private static File findSshDir() {
        File sshDir;
        String sshDirPath = System.getProperty("vfs.sftp.sshdir");
        if (sshDirPath != null && (sshDir = new File(sshDirPath)).exists()) {
            return sshDir;
        }
        sshDir = new File(System.getProperty("user.home"), SSH_DIR_NAME);
        if (sshDir.exists()) {
            return sshDir;
        }
        if (Os.isFamily(Os.OS_FAMILY_WINDOWS)) {
            String userName = System.getProperty("user.name");
            sshDir = new File("C:\\cygwin\\home\\" + userName + "\\" + SSH_DIR_NAME);
            if (sshDir.exists()) {
                return sshDir;
            }
        }
        return new File("");
    }
}

