/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.cpcontainer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.swt.widgets.Display;
import org.jayasoft.ivyde.eclipse.IvyPlugin;
import org.jayasoft.ivyde.eclipse.cpcontainer.IvyClasspathContainer;
import org.jayasoft.ivyde.eclipse.cpcontainer.IvyClasspathUtil;
import org.jayasoft.ivyde.eclipse.cpcontainer.fragmentinfo.IPackageFragmentExtraInfo;

public class IvyClasspathInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (IvyClasspathContainer.isIvyClasspathContainer(containerPath)) {
            try {
                String ivyFilePath = IvyClasspathContainer.getIvyFilePath(containerPath);
                String[] confs = IvyClasspathContainer.getConfigurations(containerPath);
                IClasspathContainer ivyClasspathContainer = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)project);
                if (!(ivyClasspathContainer instanceof IvyClasspathContainer)) {
                    ivyClasspathContainer = new IvyClasspathContainer(project, containerPath, ivyFilePath, confs);
                }
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{ivyClasspathContainer}, null);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, final IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        if (IvyClasspathContainer.isIvyClasspathContainer(containerPath)) {
            IClasspathEntry[] ice = containerSuggestion.getClasspathEntries();
            IPackageFragmentExtraInfo ei = IvyPlugin.getDefault().getPackageFragmentExtraInfo();
            int i = 0;
            while (i < ice.length) {
                IClasspathEntry entry = ice[i];
                IPath path = entry.getSourceAttachmentPath();
                String entryPath = entry.getPath().toPortableString();
                ei.setSourceAttachmentPath(containerPath, entryPath, path);
                ei.setSourceAttachmentRootPath(containerPath, entryPath, path);
                ei.setJavaDocLocation(containerPath, entryPath, JavaDocLocations.getLibraryJavadocLocation((IClasspathEntry)entry));
                ++i;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IvyClasspathUtil.refreshContainer(project);
                }
            });
        }
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        return "my description";
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return String.valueOf(project.getProject().getName()) + "/" + containerPath;
    }
}

